/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherRangedAttackGoal;
import insane96mcp.progressivebosses.network.MessageWitherSync;
import insane96mcp.progressivebosses.network.PacketManager;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;

@Label(name="Attack", description="Makes the Wither smarter (will no longer try to stand on the player's head ...), attack faster and hit harder")
public class AttackFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> applyToVanillaWitherConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxChargeAttackChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> increasedDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxBarrageChancePerDiffConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minBarrageDurationConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxBarrageDurationConfig;
    private final ForgeConfigSpec.ConfigValue<Double> skullVelocityMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> attackIntervalConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> increaseAttackSpeedWhenNearConfig;
    public boolean applyToVanillaWither = true;
    public double maxChargeAttackChance = 0.06;
    public double increasedDamage = 0.12;
    public double maxBarrageChancePerDiff = 0.011;
    public int minBarrageDuration = 20;
    public int maxBarrageDuration = 150;
    public double skullVelocityMultiplier = 2.75;
    public int attackInterval = 40;
    public boolean increaseAttackSpeedWhenNear = true;

    public AttackFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.applyToVanillaWitherConfig = Config.builder.comment("If the AI changes should be applied to the first wither spawned too.").define("Apply to Vanilla Wither", this.applyToVanillaWither);
        this.maxChargeAttackChanceConfig = Config.builder.comment("Chance every time the Wither takes damage to start a charge attack. Less health = higher chance and more damage taken = more chance. This value is the chance at 0% health and when taking 10 damage.").defineInRange("Max Charge Attack Chance", this.maxChargeAttackChance, 0.0, 1.0);
        this.increasedDamageConfig = Config.builder.comment("Percentage bonus damage dealt by the Wither per difficulty.").defineInRange("Increased Damage", this.increasedDamage, 0.0, Double.MAX_VALUE);
        Config.builder.push("Barrage Attack");
        this.maxBarrageChancePerDiffConfig = Config.builder.comment("Chance (per difficulty) every time the Wither takes damage to start a barrage attack. Less health = higher chance and more damage taken = more chance. This value is the chance at 0% health and when taking 10 damage.").defineInRange("Max Barrage Attack Chance Per Difficulty", this.maxBarrageChancePerDiff, 0.0, 1.0);
        this.minBarrageDurationConfig = Config.builder.comment("Min time (in ticks) for the duration of the barrage attack. Less health = longer barrage.").defineInRange("Min Barrage Duration", this.minBarrageDuration, 0, Integer.MAX_VALUE);
        this.maxBarrageDurationConfig = Config.builder.comment("Max time (in ticks) for the duration of the barrage attack. Less health = longer barrage").defineInRange("Max Barrage Duration", this.maxBarrageDuration, 0, Integer.MAX_VALUE);
        Config.builder.pop();
        Config.builder.comment("Wither Skull Changes").push("Skulls");
        this.skullVelocityMultiplierConfig = Config.builder.comment("Wither Skull Projectiles speed will be multiplied by this value.").defineInRange("Skull Velocity Multiplier", this.skullVelocityMultiplier, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
        Config.builder.comment("Attack Speed Changes").push("Attack Speed");
        this.attackIntervalConfig = Config.builder.comment("Every how many ticks (20 ticks = 1 seconds) the middle head will fire a projectile to the target.").defineInRange("Attack Interval", this.attackInterval, 0, Integer.MAX_VALUE);
        this.increaseAttackSpeedWhenNearConfig = Config.builder.comment("The middle head will attack faster (up to 40% of the attack speed) the nearer the target is to the Wither.").define("Increase Attack Speed when Near", this.increaseAttackSpeedWhenNear);
        Config.builder.pop();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.applyToVanillaWither = (Boolean)this.applyToVanillaWitherConfig.get();
        this.maxChargeAttackChance = (Double)this.maxChargeAttackChanceConfig.get();
        this.increasedDamage = (Double)this.increasedDamageConfig.get();
        this.maxBarrageChancePerDiff = (Double)this.maxBarrageChancePerDiffConfig.get();
        this.minBarrageDuration = (Integer)this.minBarrageDurationConfig.get();
        this.maxBarrageDuration = (Integer)this.maxBarrageDurationConfig.get();
        this.skullVelocityMultiplier = (Double)this.skullVelocityMultiplierConfig.get();
        this.attackInterval = (Integer)this.attackIntervalConfig.get();
        this.increaseAttackSpeedWhenNear = (Boolean)this.increaseAttackSpeedWhenNearConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        this.witherSkullSpeed(event.getEntity());
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        CompoundTag compoundNBT = wither.getPersistentData();
        if (!(compoundNBT.m_128441_("progressivebosses:difficulty") && compoundNBT.m_128457_("progressivebosses:difficulty") != 0.0f || this.applyToVanillaWither)) {
            return;
        }
        this.setWitherAI(wither);
    }

    private void witherSkullSpeed(Entity entity) {
        if (!(entity instanceof WitherSkull)) {
            return;
        }
        WitherSkull witherSkullEntity = (WitherSkull)entity;
        if (!this.isEnabled() || this.skullVelocityMultiplier == 0.0) {
            return;
        }
        if (Math.abs(witherSkullEntity.f_36813_) > 10.0 || Math.abs(witherSkullEntity.f_36814_) > 10.0 || Math.abs(witherSkullEntity.f_36815_) > 10.0) {
            entity.m_6074_();
            return;
        }
        witherSkullEntity.f_36813_ *= this.skullVelocityMultiplier;
        witherSkullEntity.f_36814_ *= this.skullVelocityMultiplier;
        witherSkullEntity.f_36815_ *= this.skullVelocityMultiplier;
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getEntity().m_6084_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        this.tickCharge(wither);
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        this.chargeUnseen(wither);
    }

    private void tickCharge(WitherBoss wither) {
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        byte chargeTick = wither.getPersistentData().m_128445_("progressivebosses:charge_attack");
        if (chargeTick > 0) {
            if (wither.f_19797_ % 10 == 0) {
                float missingHealth = wither.m_21233_() - wither.m_21223_();
                wither.m_21153_(wither.m_21223_() + missingHealth * 0.005f);
            }
            wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)(chargeTick - 1));
        }
    }

    private void chargeUnseen(WitherBoss wither) {
        CompoundTag witherTags = wither.getPersistentData();
        if (witherTags.m_128445_("progressivebosses:charge_attack") <= 0 && wither.f_19797_ % 20 == 0) {
            this.doCharge(wither, (float)witherTags.m_128451_("progressivebosses:unseen_player_ticks") / 20.0f);
        }
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        WitherBoss wither;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.increasedDamage == 0.0) {
            return;
        }
        if (event.getSource().m_7640_() instanceof WitherBoss) {
            wither = (WitherBoss)event.getSource().m_7640_();
        } else if (event.getSource().m_7639_() instanceof WitherBoss) {
            wither = (WitherBoss)event.getSource().m_7639_();
        } else {
            return;
        }
        CompoundTag compoundNBT = wither.getPersistentData();
        float difficulty = compoundNBT.m_128457_("progressivebosses:difficulty");
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedDamage * (double)difficulty));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDamaged(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getEntity().m_6084_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        this.doBarrage(wither, event.getAmount());
        this.doCharge(wither, event.getAmount());
    }

    private void doBarrage(WitherBoss wither, float damageTaken) {
        if (this.maxBarrageChancePerDiff == 0.0) {
            return;
        }
        CompoundTag witherTags = wither.getPersistentData();
        float difficulty = witherTags.m_128457_("progressivebosses:difficulty");
        double missingHealthPerc = 1.0 - (double)(wither.m_21223_() / wither.m_21233_());
        double chance = this.maxBarrageChancePerDiff * (double)difficulty * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.m_21187_().nextDouble();
        if (r < chance) {
            int duration = (int)((double)(this.maxBarrageDuration - this.minBarrageDuration) * missingHealthPerc + (double)this.minBarrageDuration);
            witherTags.m_128405_("progressivebosses:barrage_attack", duration);
        }
    }

    private void doCharge(WitherBoss wither, float damageTaken) {
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        if (wither.getPersistentData().m_128445_("progressivebosses:charge_attack") > 0) {
            return;
        }
        double missingHealthPerc = 1.0 - (double)(wither.m_21223_() / wither.m_21233_());
        double chance = this.maxChargeAttackChance * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.m_21187_().nextDouble();
        if (r < chance) {
            AttackFeature.initCharging(wither);
        }
    }

    public void setWitherAI(WitherBoss wither) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        wither.f_21345_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof RangedAttackGoal) {
                toRemove.add(goal.m_26015_());
            }
            if (goal.m_26015_() instanceof WitherBoss.WitherDoNothingGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)wither.f_21345_).m_25363_(arg_0));
        wither.f_21345_.m_25352_(1, (Goal)new WitherChargeAttackGoal(wither));
        wither.f_21345_.m_25352_(2, (Goal)new WitherRangedAttackGoal(wither, this.attackInterval, 24.0f, this.increaseAttackSpeedWhenNear));
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.f_22277_, (UUID)UUID.randomUUID(), (String)"Wither Glasses", (double)48.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    public static void initCharging(WitherBoss wither) {
        wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)90);
        MessageWitherSync msg = new MessageWitherSync(wither.m_142049_(), 90);
        for (Player player : wither.f_19853_.m_6907_()) {
            PacketManager.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void stopCharging(WitherBoss wither) {
        wither.getPersistentData().m_128344_("progressivebosses:charge_attack", (byte)0);
        MessageWitherSync msg = new MessageWitherSync(wither.m_142049_(), 0);
        for (Player player : wither.f_19853_.m_6907_()) {
            PacketManager.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static class Consts {
        public static final int CHARGE_ATTACK_TICK_START = 90;
        public static final int CHARGE_ATTACK_TICK_CHARGE = 30;
    }
}

