/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> meleeDamageReductionBeforeHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxMeleeDamageReductionBeforeHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> meleeDamageReductionOnHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maxMeleeDamageReductionOnHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> magicDamageBonusConfig;
    public double meleeDamageReductionBeforeHalfHealth = 0.03;
    public double maxMeleeDamageReductionBeforeHalfHealth = 0.24;
    public double meleeDamageReductionOnHalfHealth = 0.06;
    public double maxDamageReductionOnHalfHealth = 0.48;
    public double magicDamageBonus = 250.0;

    public ResistancesFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.meleeDamageReductionBeforeHalfHealthConfig = Config.builder.comment("Percentage Melee Damage Reduction (per difficulty) while the Wither is above half health.").defineInRange("Melee Damage reduction per Difficulty above half health", this.meleeDamageReductionBeforeHalfHealth, 0.0, 1.0);
        this.maxMeleeDamageReductionBeforeHalfHealthConfig = Config.builder.comment("Cap for 'Melee Damage reduction per Difficulty above half health'").defineInRange("Max Melee Damage reduction per Difficulty before half health", this.maxMeleeDamageReductionBeforeHalfHealth, 0.0, 1.0);
        this.meleeDamageReductionOnHalfHealthConfig = Config.builder.comment("Percentage Melee Damage Reduction (per difficulty) as the Wither drops below half health.").defineInRange("Melee Damage reduction per Difficulty below half health", this.meleeDamageReductionOnHalfHealth, 0.0, 1.0);
        this.maxMeleeDamageReductionOnHalfHealthConfig = Config.builder.comment("Cap for 'Melee Damage Reduction per Difficulty below half health'").defineInRange("Max Melee Damage reduction per Difficulty below half health", this.maxDamageReductionOnHalfHealth, 0.0, 1.0);
        this.magicDamageBonusConfig = Config.builder.comment("Bonus magic damage based off missing health. 150 means that every 150 missing health the damage will be amplified by 100%. E.g. The difficulty = 0 Wither (with 300 max health) is at half health (so it's missing 150hp), on magic damage he will receive 'magic_damage * (missing_health / magic_damage_bonus + 1)' = 'magic_damage * (150 / 150 + 1)' = 'magic_damage * 2'.").defineInRange("Magic Damage Bonus", this.magicDamageBonus, 0.0, 1024.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.meleeDamageReductionBeforeHalfHealth = (Double)this.meleeDamageReductionBeforeHalfHealthConfig.get();
        this.maxMeleeDamageReductionBeforeHalfHealth = (Double)this.maxMeleeDamageReductionBeforeHalfHealthConfig.get();
        this.meleeDamageReductionOnHalfHealth = (Double)this.meleeDamageReductionOnHalfHealthConfig.get();
        this.maxDamageReductionOnHalfHealth = (Double)this.maxMeleeDamageReductionOnHalfHealthConfig.get();
        this.magicDamageBonus = (Double)this.magicDamageBonusConfig.get();
    }

    @SubscribeEvent
    public void onWitherDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (!(this.meleeDamageReductionOnHalfHealth != 0.0 && this.maxDamageReductionOnHalfHealth != 0.0 || this.meleeDamageReductionBeforeHalfHealth != 0.0 && this.maxMeleeDamageReductionBeforeHalfHealth != 0.0 || this.magicDamageBonus != 0.0)) {
            return;
        }
        if (event.getSource().m_19387_() && this.magicDamageBonus > 0.0) {
            double missingHealth = wither.m_21233_() - wither.m_21223_();
            event.setAmount(event.getAmount() * (float)(missingHealth / this.magicDamageBonus + 1.0));
        }
        if (event.getSource().m_7640_() != event.getSource().m_7639_()) {
            return;
        }
        CompoundTag tags = wither.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        float damageReduction = !wither.m_7090_() ? (float)Math.min(this.maxMeleeDamageReductionBeforeHalfHealth, (double)difficulty * this.meleeDamageReductionBeforeHalfHealth) : (float)Math.min(this.maxDamageReductionOnHalfHealth, (double)difficulty * this.meleeDamageReductionOnHalfHealth);
        if ((double)damageReduction == 0.0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

