/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.progressivebosses.capability.DifficultyCapability;
import insane96mcp.progressivebosses.capability.IDifficulty;
import insane96mcp.progressivebosses.setup.Config;
import java.util.List;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Dragon.")
public class DifficultyFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> sumKilledDragonDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusDifficultyPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> startingDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> showFirstKilledDragonMessageConfig;
    public boolean sumKilledDragonDifficulty = false;
    public double bonusDifficultyPerPlayer = 0.25;
    public int maxDifficulty = 24;
    public int startingDifficulty = 0;
    public boolean showFirstKilledDragonMessage = true;

    public DifficultyFeature(Module module) {
        super(Config.builder, module, true, false);
        this.pushConfig(Config.builder);
        this.sumKilledDragonDifficultyConfig = Config.builder.comment("If false and there's more than 1 player around the Dragon, difficulty will be the average of all the players' difficulty instead of summing them.").define("Sum Killed Dragons Difficulty", this.sumKilledDragonDifficulty);
        this.bonusDifficultyPerPlayerConfig = Config.builder.comment("Percentage bonus difficulty added to the Dragon when more than one player is present. Each player past the first one will add this percentage to the difficulty.").defineInRange("Bonus Difficulty per Player", this.bonusDifficultyPerPlayer, 0.0, 24.0);
        this.maxDifficultyConfig = Config.builder.comment("The Maximum difficulty (times killed) reachable by Ender Dragon. By default is set to 24 because it's the last spawning end gate.").defineInRange("Max Difficulty", this.maxDifficulty, 1, Integer.MAX_VALUE);
        this.startingDifficultyConfig = Config.builder.comment("How much difficulty will players start with when joining a world? Note that this will apply when the player joins the world if the current player difficulty is below this value.").defineInRange("Starting Difficulty", this.startingDifficulty, 0, Integer.MAX_VALUE);
        this.showFirstKilledDragonMessageConfig = Config.builder.comment("Set to false to disable the first Dragon killed message.").define("Show First Killed Dragon Message", this.showFirstKilledDragonMessage);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.sumKilledDragonDifficulty = (Boolean)this.sumKilledDragonDifficultyConfig.get();
        this.bonusDifficultyPerPlayer = (Double)this.bonusDifficultyPerPlayerConfig.get();
        this.maxDifficulty = (Integer)this.maxDifficultyConfig.get();
        this.startingDifficulty = (Integer)this.startingDifficultyConfig.get();
        this.showFirstKilledDragonMessage = (Boolean)this.showFirstKilledDragonMessageConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getWorld().func_234923_W_().func_240901_a_().equals((Object)DimensionType.field_236001_e_.func_240901_a_())) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        if (dragon.func_184664_cU() == null) {
            return;
        }
        CompoundNBT dragonTags = dragon.getPersistentData();
        if (dragonTags.func_74764_b("progressivebosses:difficulty")) {
            return;
        }
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_225317_b(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            return;
        }
        int playersFirstDragon = 0;
        float dragonDifficulty = 0.0f;
        for (ServerPlayerEntity player : players) {
            IDifficulty difficulty = (IDifficulty)player.getCapability(DifficultyCapability.DIFFICULTY).orElse(null);
            dragonDifficulty += (float)difficulty.getKilledDragons();
            if (difficulty.getFirstDragon() != 1) continue;
            ++playersFirstDragon;
            difficulty.setFirstDragon((byte)2);
        }
        dragonTags.func_74768_a("progressivebosses:eggs_to_drop", playersFirstDragon);
        if (!this.sumKilledDragonDifficulty) {
            dragonDifficulty /= (float)players.size();
        }
        if (players.size() > 1) {
            dragonDifficulty = (float)((double)dragonDifficulty * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        dragonTags.func_74776_a("progressivebosses:difficulty", dragonDifficulty);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = dragon.field_70170_p.func_225317_b(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            ServerPlayerEntity nearestPlayer = (ServerPlayerEntity)dragon.field_70170_p.func_217366_a(dragon.func_226277_ct_(), dragon.func_226278_cu_(), dragon.func_226281_cx_(), Double.MAX_VALUE, true);
            players.add(nearestPlayer);
        }
        for (ServerPlayerEntity player : players) {
            IDifficulty difficulty = (IDifficulty)player.getCapability(DifficultyCapability.DIFFICULTY).orElse(null);
            if (difficulty.getKilledDragons() <= this.startingDifficulty && this.showFirstKilledDragonMessage) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("dragon.first_killed"), Util.field_240973_b_);
            }
            if (difficulty.getKilledDragons() >= this.maxDifficulty) continue;
            difficulty.addKilledDragons(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        IDifficulty difficulty = (IDifficulty)player.getCapability(DifficultyCapability.DIFFICULTY).orElse(null);
        if (difficulty.getKilledDragons() < this.startingDifficulty) {
            difficulty.setKilledDragons(this.startingDifficulty);
            LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", (Object[])new Object[]{player.func_200200_C_().getString()});
        }
        if (difficulty.getKilledDragons() > this.maxDifficulty) {
            difficulty.setKilledDragons(this.maxDifficulty);
            LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was above the 'Max Difficulty', Has been decreased to match 'Max Difficulty'", (Object[])new Object[]{player.func_200200_C_().getString()});
        }
        if (difficulty.getFirstDragon() == 0) {
            difficulty.setFirstDragon((byte)1);
            LogHelper.info((String)"[Progressive Bosses] %s first spawned. Set First Dragon to 1", (Object[])new Object[]{player.func_200200_C_().getString()});
        }
    }
}

