/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.module.dragon.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.module.dragon.ai.PBNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.DragonMinionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Shulkers that will make you float around.")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> minionAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Double> cooldownReductionConfig;
    private final ForgeConfigSpec.ConfigValue<Double> blindingChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> dragonImmuneConfig;
    public int minionAtDifficulty = 1;
    public int minCooldown = 1400;
    public int maxCooldown = 2000;
    public double cooldownReduction = 0.017;
    public double blindingChance = 0.015;
    public boolean dragonImmune = true;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.minionAtDifficultyConfig = Config.builder.comment("At which difficulty the Ender Dragon starts spawning Minions").defineInRange("Minion at Difficulty", this.minionAtDifficulty, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.cooldownReductionConfig = Config.builder.comment("Percentage cooldown reduction per difficulty for the cooldown of Minion spawning.").defineInRange("Cooldown Reduction", this.cooldownReduction, 0.0, 1.0);
        this.blindingChanceConfig = Config.builder.comment("Percentage chance per difficulty for a Minion to spawn as a Blinding Minion.").defineInRange("Blinding Chance", this.blindingChance, 0.0, 1.0);
        this.dragonImmuneConfig = Config.builder.comment("Dragon Minions are immune to any damage from the Ender Dragon, either direct or Acid.").define("Dragon Immune", this.dragonImmune);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.minionAtDifficulty = (Integer)this.minionAtDifficultyConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.cooldownReduction = (Double)this.cooldownReductionConfig.get();
        this.blindingChance = (Double)this.blindingChanceConfig.get();
        this.dragonImmune = (Boolean)this.dragonImmuneConfig.get();
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt((Random)dragon.func_70681_au(), (int)this.minCooldown, (int)this.maxCooldown) * 0.5);
        dragonTags.func_74768_a("progressivebosses:dragon_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void onShulkerSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ShulkerEntity)) {
            return;
        }
        ShulkerEntity shulker = (ShulkerEntity)event.getEntity();
        CompoundNBT tags = shulker.getPersistentData();
        if (!tags.func_74764_b("progressivebosses:dragon_minion")) {
            return;
        }
        MinionFeature.setMinionAI(shulker);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof EnderDragonEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        EnderDragonEntity dragon = (EnderDragonEntity)event.getEntity();
        CompoundNBT dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (dragon.func_110143_aJ() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.func_74762_e("progressivebosses:dragon_minion_cooldown");
        if (cooldown > 0) {
            dragonTags.func_74768_a("progressivebosses:dragon_minion_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
        AxisAlignedBB bb = new AxisAlignedBB(centerPodium).func_186662_g(96.0);
        List players = world.func_225317_b(ServerPlayerEntity.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt((Random)world.field_73012_v, (int)minCooldown, (int)maxCooldown);
        cooldown = (int)((double)cooldown * (1.0 - this.cooldownReduction * (double)difficulty));
        dragonTags.func_74768_a("progressivebosses:dragon_minion_cooldown", cooldown - 1);
        float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        float x = (float)(Math.cos(angle) * (double)RandomHelper.getFloat((Random)dragon.func_70681_au(), (float)16.0f, (float)46.0f));
        float z = (float)(Math.sin(angle) * (double)RandomHelper.getFloat((Random)dragon.func_70681_au(), (float)16.0f, (float)46.0f));
        float y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos((double)x, 255.0, (double)z)).func_177956_o();
        ShulkerEntity shulker = this.summonMinion(world, new Vector3d((double)x, (double)y, (double)z), difficulty);
    }

    private static void setMinionAI(ShulkerEntity shulker) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        shulker.field_70714_bg.field_220892_d.forEach(goal -> {
            if (goal.func_220772_j() instanceof ShulkerEntity.AttackGoal) {
                toRemove.add(goal.func_220772_j());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.field_70714_bg).func_85156_a(arg_0));
        shulker.field_70714_bg.func_75776_a(2, (Goal)new DragonMinionAttackGoal(shulker, 70));
        toRemove.clear();
        shulker.field_70715_bh.field_220892_d.forEach(goal -> {
            if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                toRemove.add(goal.func_220772_j());
            }
            if (goal.func_220772_j() instanceof HurtByTargetGoal) {
                toRemove.add(goal.func_220772_j());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.field_70715_bh).func_85156_a(arg_0));
        shulker.field_70715_bh.func_75776_a(2, (Goal)new PBNearestAttackableTargetGoal((MobEntity)shulker));
        shulker.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)shulker, new Class[]{ShulkerEntity.class, EnderDragonEntity.class}));
    }

    public ShulkerEntity summonMinion(World world, Vector3d pos, float difficulty) {
        ShulkerEntity shulker = new ShulkerEntity(EntityType.field_200738_ad, world);
        CompoundNBT minionTags = shulker.getPersistentData();
        minionTags.func_74757_a("progressivebosses:dragon_minion", true);
        minionTags.func_74757_a("mobspropertiesrandomness:processed", true);
        boolean isBlindingMinion = world.func_201674_k().nextDouble() < this.blindingChance * (double)difficulty;
        shulker.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        shulker.func_200203_b((ITextComponent)new TranslationTextComponent("progressivebosses:dragon_minion"));
        shulker.field_184659_bA = LootTables.field_186419_a;
        shulker.func_110163_bv();
        DragonMinionHelper.setMinionColor(shulker, isBlindingMinion);
        MCUtils.applyModifier((LivingEntity)shulker, (Attribute)Attributes.field_233819_b_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)64.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        world.func_217376_c((Entity)shulker);
        return shulker;
    }

    @SubscribeEvent
    public void onMinionHurt(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragonImmune) {
            return;
        }
        if (!(event.getEntity() instanceof ShulkerEntity)) {
            return;
        }
        ShulkerEntity shulker = (ShulkerEntity)event.getEntity();
        CompoundNBT compoundNBT = shulker.getPersistentData();
        if (!compoundNBT.func_74764_b("progressivebosses:dragon_minion")) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EnderDragonEntity || event.getSource().func_76364_f() instanceof EnderDragonEntity) {
            event.setCanceled(true);
        }
    }

    public void onBulletTick(ShulkerBulletEntity shulkerBulletEntity) {
        if (!shulkerBulletEntity.field_70170_p.field_72995_K && shulkerBulletEntity.getPersistentData().func_74767_n("progressivebosses:blindness_bullet")) {
            ((ServerWorld)shulkerBulletEntity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197625_r, shulkerBulletEntity.func_226277_ct_(), shulkerBulletEntity.func_226278_cu_(), shulkerBulletEntity.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void onBulletEntityHit(ShulkerBulletEntity shulkerBulletEntity, EntityRayTraceResult rayTraceResult) {
        Entity entityOwner;
        LivingEntity livingEntityOwner;
        Entity entityHit = rayTraceResult.func_216348_a();
        boolean flag = entityHit.func_70097_a(DamageSource.func_188403_a((Entity)shulkerBulletEntity, (LivingEntity)(livingEntityOwner = (entityOwner = shulkerBulletEntity.func_234616_v_()) instanceof LivingEntity ? (LivingEntity)entityOwner : null)).func_76349_b(), 4.0f);
        if (flag) {
            shulkerBulletEntity.func_174815_a(livingEntityOwner, entityHit);
            if (entityHit instanceof LivingEntity) {
                ((LivingEntity)entityHit).func_195064_c(new EffectInstance(Effects.field_188424_y, 200));
                if (shulkerBulletEntity.getPersistentData().func_74767_n("progressivebosses:blindness_bullet")) {
                    ((LivingEntity)entityHit).func_195064_c(new EffectInstance(Effects.field_76440_q, 150));
                }
            }
        }
    }
}

