/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Attack", description="More damage and attack speed based off Elder Guardians Defeated")
public class AttackFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusDamageConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> attackDurationReductionConfig;
    public double bonusDamage = 0.1;
    public int attackDurationReduction = 25;
    private static final int BASE_ATTACK_DURATION = 60;

    public AttackFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusDamageConfig = Config.builder.comment("Percentage Bonus damage per defeated Elder Guardian.").defineInRange("Bonus Damage per Elder Guardian Defeated", this.bonusDamage, 0.0, 128.0);
        this.attackDurationReductionConfig = Config.builder.comment("How many ticks faster will Elder Guardian attack (multiplied by defeated Elder Guardians). Vanilla Attack Duration is 60 ticks (3 secs)").defineInRange("Attack Duration Reduction per Elder Guardian Defeated", this.attackDurationReduction, 0, 60);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusDamage = (Double)this.bonusDamageConfig.get();
        this.attackDurationReduction = (Integer)this.attackDurationReductionConfig.get();
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusDamage == 0.0) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof ElderGuardianEntity)) {
            return;
        }
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getSource().func_76346_g();
        float bonusDamage = (float)(this.bonusDamage * (double)BaseFeature.getDeadElderGuardians(elderGuardian));
        event.setAmount(event.getAmount() * (1.0f + bonusDamage));
    }

    public int getAttackDuration(ElderGuardianEntity elderGuardian) {
        if (!this.isEnabled() || this.attackDurationReduction == 0) {
            return 60;
        }
        int elderGuardiansNearby = elderGuardian.field_70170_p.func_175674_a((Entity)elderGuardian, elderGuardian.func_174813_aQ().func_186662_g(48.0), entity -> entity instanceof ElderGuardianEntity).size();
        if (elderGuardiansNearby == 2) {
            return 60;
        }
        return 60 - (2 - elderGuardiansNearby) * this.attackDurationReduction;
    }
}

