/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Base", description="Base feature for the Elder Guardian harder fights. Disabling this feature will disable the added sound when an Elder Guardian is killed.")
public class BaseFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> adventureConfig;
    public boolean adventure = true;

    public BaseFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.adventureConfig = Config.builder.comment("If true, the player will not be able to break blocks when an Elder Guardian is nearby.").define("Adventure mode", this.adventure);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.adventure = (Boolean)this.adventureConfig.get();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (event.player.field_70173_aa % 20 != 0) {
            return;
        }
        if (!event.player.func_70089_S()) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.player;
        ServerWorld world = (ServerWorld)serverPlayer.field_70170_p;
        CompoundNBT nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.func_74767_n("progressivebosses:previously_near_elder_guardian");
        boolean adventureMessage = nbt.func_74767_n("progressivebosses:adventure_message");
        boolean nearElderGuardian = !world.func_175647_a(ElderGuardianEntity.class, serverPlayer.func_174813_aQ().func_186662_g(32.0), null).isEmpty();
        nbt.func_74757_a("progressivebosses:previously_near_elder_guardian", nearElderGuardian);
        if (serverPlayer.field_71134_c.func_73081_b() == GameType.SURVIVAL && nearElderGuardian) {
            serverPlayer.field_71134_c.func_73076_a(GameType.ADVENTURE);
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241767_d_, (float)GameType.ADVENTURE.func_77148_a()));
            if (!adventureMessage) {
                serverPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("elder_guardian.approach"), Util.field_240973_b_);
                nbt.func_74757_a("progressivebosses:adventure_message", true);
            }
        } else if (serverPlayer.field_71134_c.func_73081_b() == GameType.ADVENTURE && !nearElderGuardian && previouslyNearElderGuardian) {
            serverPlayer.field_71134_c.func_73076_a(GameType.SURVIVAL);
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241767_d_, (float)GameType.SURVIVAL.func_77148_a()));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.getEntity();
        CompoundNBT nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.func_74767_n("progressivebosses:previously_near_elder_guardian");
        if (previouslyNearElderGuardian && serverPlayer.field_71134_c.func_73081_b() == GameType.ADVENTURE) {
            serverPlayer.field_71134_c.func_73076_a(GameType.SURVIVAL);
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241767_d_, (float)GameType.SURVIVAL.func_77148_a()));
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Start event) {
        boolean nearElderGuardian;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (event.getExplosion().getExploder() == null) {
            return;
        }
        if (event.getExplosion().field_222260_b == Explosion.Mode.NONE) {
            return;
        }
        boolean bl = nearElderGuardian = !event.getWorld().func_217357_a(ElderGuardianEntity.class, event.getExplosion().getExploder().func_174813_aQ().func_186662_g(32.0)).isEmpty();
        if (nearElderGuardian) {
            event.setCanceled(true);
            event.getWorld().func_217398_a(event.getExplosion().getExploder(), event.getExplosion().getPosition().field_72450_a, event.getExplosion().getPosition().field_72448_b, event.getExplosion().getPosition().field_72449_c, event.getExplosion().field_77280_f, event.getExplosion().field_77286_a, Explosion.Mode.NONE);
        }
    }

    @SubscribeEvent
    public void onElderGuardianDeath(LivingDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ElderGuardianEntity)) {
            return;
        }
        ElderGuardianEntity elderGuardian = (ElderGuardianEntity)event.getEntity();
        int elderGuardiansNearby = elderGuardian.field_70170_p.func_175674_a((Entity)elderGuardian, elderGuardian.func_174813_aQ().func_186662_g(48.0), entity -> entity instanceof ElderGuardianEntity).size();
        if (elderGuardiansNearby == 0) {
            return;
        }
        elderGuardian.func_184185_a(SoundEvents.field_187514_aD, 2.0f, 0.5f);
    }

    public static int getDeadElderGuardians(ElderGuardianEntity elderGuardian) {
        int elderGuardiansNearby = elderGuardian.field_70170_p.func_175674_a((Entity)elderGuardian, elderGuardian.func_174813_aQ().func_186662_g(48.0), entity -> entity instanceof ElderGuardianEntity).size();
        return 2 - elderGuardiansNearby;
    }
}

