/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.LogHelper;
import insane96mcp.progressivebosses.capability.DifficultyCapability;
import insane96mcp.progressivebosses.capability.IDifficulty;
import insane96mcp.progressivebosses.setup.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Wither.")
public class DifficultyFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> spawnRadiusPlayerCheckConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> sumSpawnedWitherDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusDifficultyPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> startingDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> showFirstSummonedWitherMessageConfig;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklistConfig;
    private static final List<String> defaultEntityBlacklist = Arrays.asList("botania:pink_wither");
    public int spawnRadiusPlayerCheck = 128;
    public boolean sumSpawnedWitherDifficulty = false;
    public double bonusDifficultyPerPlayer = 0.25;
    public int maxDifficulty = 24;
    public int startingDifficulty = 0;
    public boolean showFirstSummonedWitherMessage = true;
    public List<String> entityBlacklist = defaultEntityBlacklist;

    public DifficultyFeature(Module module) {
        super(Config.builder, module, true, false);
        this.pushConfig(Config.builder);
        this.spawnRadiusPlayerCheckConfig = Config.builder.comment("How much blocks from wither will be scanned for players to check for difficulty").defineInRange("Spawn Radius Player Check", this.spawnRadiusPlayerCheck, 16, Integer.MAX_VALUE);
        this.sumSpawnedWitherDifficultyConfig = Config.builder.comment("If false and there's more than 1 player around the Wither, difficulty will be the average of all the players' difficulty instead of summing them.").define("Sum Spawned Wither Difficulty", this.sumSpawnedWitherDifficulty);
        this.bonusDifficultyPerPlayerConfig = Config.builder.comment("Percentage bonus difficulty added to the Wither when more than one player is present. Each player past the first one will add this percentage to the difficulty.").defineInRange("Bonus Difficulty per Player", this.bonusDifficultyPerPlayer, 0.0, 24.0);
        this.maxDifficultyConfig = Config.builder.comment("The Maximum difficulty (times spawned) reachable by Wither.").defineInRange("Max Difficulty", this.maxDifficulty, 1, Integer.MAX_VALUE);
        this.startingDifficultyConfig = Config.builder.comment("How much difficulty will players start with when joining a world? Note that this will apply when the first Wither is spawned so if the player has already spawned one this will not apply.").defineInRange("Starting Difficulty", this.startingDifficulty, 0, Integer.MAX_VALUE);
        this.showFirstSummonedWitherMessageConfig = Config.builder.comment("Set to false to disable the first Wither summoned message.").define("Show First Summoned Wither Message", this.showFirstSummonedWitherMessage);
        this.entityBlacklistConfig = Config.builder.comment("Entities that extend the vanilla Wither but shouldn't be taken into account by the mod (e.g. Botania's Pink Wither).").defineList("Entity Blacklist", this.entityBlacklist, o -> o instanceof String);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.spawnRadiusPlayerCheck = (Integer)this.spawnRadiusPlayerCheckConfig.get();
        this.sumSpawnedWitherDifficulty = (Boolean)this.sumSpawnedWitherDifficultyConfig.get();
        this.bonusDifficultyPerPlayer = (Double)this.bonusDifficultyPerPlayerConfig.get();
        this.maxDifficulty = (Integer)this.maxDifficultyConfig.get();
        this.startingDifficulty = (Integer)this.startingDifficultyConfig.get();
        this.showFirstSummonedWitherMessage = (Boolean)this.showFirstSummonedWitherMessageConfig.get();
        this.entityBlacklist = new ArrayList<String>();
        for (String string : (List)this.entityBlacklistConfig.get()) {
            if (!ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(string))) {
                LogHelper.warn((String)"Entity %s for Wither's Difficulty Feature entityBlacklist doesn't exist, will be ignored.", (Object[])new Object[]{string});
            }
            this.entityBlacklist.add(string);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        if (this.entityBlacklist.contains(event.getEntity().func_200600_R().getRegistryName().toString())) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT witherTags = wither.getPersistentData();
        if (witherTags.func_74764_b("progressivebosses:difficulty")) {
            return;
        }
        BlockPos pos1 = wither.func_233580_cy_().func_177982_a(-this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck);
        BlockPos pos2 = wither.func_233580_cy_().func_177982_a(this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_225317_b(ServerPlayerEntity.class, bb);
        if (players.size() == 0) {
            return;
        }
        float witherDifficulty = 0.0f;
        for (ServerPlayerEntity player : players) {
            IDifficulty difficulty = (IDifficulty)player.getCapability(DifficultyCapability.DIFFICULTY).orElse(null);
            witherDifficulty += (float)difficulty.getSpawnedWithers();
            if (difficulty.getSpawnedWithers() >= this.maxDifficulty) continue;
            if (difficulty.getKilledDragons() <= this.startingDifficulty && this.showFirstSummonedWitherMessage) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("wither.first_summon"), Util.field_240973_b_);
            }
            difficulty.addSpawnedWithers(1);
        }
        if (!this.sumSpawnedWitherDifficulty) {
            witherDifficulty /= (float)players.size();
        }
        if (players.size() > 1) {
            witherDifficulty = (float)((double)witherDifficulty * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        witherTags.func_74776_a("progressivebosses:difficulty", witherDifficulty);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        IDifficulty difficulty = (IDifficulty)player.getCapability(DifficultyCapability.DIFFICULTY).orElse(null);
        if (difficulty.getSpawnedWithers() < this.startingDifficulty) {
            difficulty.setSpawnedWithers(this.startingDifficulty);
            LogHelper.info((String)"[Progressive Bosses] %s spawned withers counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", (Object[])new Object[]{player.func_200200_C_().getString()});
        }
    }
}

