/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.utils.MCUtils;
import insane96mcp.insanelib.utils.RandomHelper;
import insane96mcp.progressivebosses.base.Strings;
import insane96mcp.progressivebosses.module.wither.entity.WitherMinionEntity;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.PBEntities;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Minions", description="Wither will spawn deadly Minions")
public class MinionFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> minionAtDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> bonusMinionEveryDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxSpawnedConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxAroundConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> minCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxCooldownConfig;
    private final ForgeConfigSpec.ConfigValue<Double> cooldownMultiplierBelowHalfHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusSpeedPerDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> magicDamageMultiplierConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> killMinionOnWitherDeathConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> hasSwordConfig;
    private final ForgeConfigSpec.ConfigValue<Double> preHalfHealthBowChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> halfHealthBowChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> powerSharpnessChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> punchKnockbackChanceConfig;
    public int minionAtDifficulty = 1;
    public int bonusMinionEveryDifficulty = 2;
    public int maxSpawned = 6;
    public int maxAround = 20;
    public int minCooldown = 300;
    public int maxCooldown = 600;
    public double cooldownMultiplierBelowHalfHealth = 0.5;
    public double bonusSpeedPerDifficulty = 0.012;
    public double magicDamageMultiplier = 3.0;
    public boolean killMinionOnWitherDeath = true;
    public boolean hasSword = true;
    public double preHalfHealthBowChance = 0.6;
    public double halfHealthBowChance = 0.08;
    public double powerSharpnessChance = 0.2;
    public double punchKnockbackChance = 0.1;

    public MinionFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.minionAtDifficultyConfig = Config.builder.comment("At which difficulty the Wither starts spawning Minions").defineInRange("Minion at Difficulty", this.minionAtDifficulty, 0, Integer.MAX_VALUE);
        this.bonusMinionEveryDifficultyConfig = Config.builder.comment("As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion").defineInRange("Bonus Minion Every Difficulty", this.bonusMinionEveryDifficulty, 0, Integer.MAX_VALUE);
        this.maxSpawnedConfig = Config.builder.comment("Maximum Minions spawned by the Wither").defineInRange("Max Minions Spawned", this.maxSpawned, 0, Integer.MAX_VALUE);
        this.maxAroundConfig = Config.builder.comment("Maximum amount of Minions that can be around the Wither in a 16 block radius. After this number is reached the Wither will stop spawning minions. Set to 0 to disable this check").defineInRange("Max Minions Around", this.maxAround, 0, Integer.MAX_VALUE);
        this.minCooldownConfig = Config.builder.comment("Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Minimum Cooldown", this.minCooldown, 0, Integer.MAX_VALUE);
        this.maxCooldownConfig = Config.builder.comment("Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.").defineInRange("Maximum Cooldown", this.maxCooldown, 0, Integer.MAX_VALUE);
        this.cooldownMultiplierBelowHalfHealthConfig = Config.builder.comment("Min and Max cooldowns are multiplied by this value when the Wither drops below half health. Set to 1 to not change the cooldown when the wither's health drops below half.").defineInRange("Cooldown Multiplier Below Half Health", this.cooldownMultiplierBelowHalfHealth, 0.0, Double.MAX_VALUE);
        this.bonusSpeedPerDifficultyConfig = Config.builder.comment("Percentage bonus speed per difficulty. (0.01 means 1%)").defineInRange("Bonus Movement Speed Per Difficulty", this.bonusSpeedPerDifficulty, 0.0, Double.MAX_VALUE);
        this.magicDamageMultiplierConfig = Config.builder.comment("Wither Minions will take magic damage multiplied by this value.").defineInRange("Magic Damage Multiplier", this.magicDamageMultiplier, 0.0, Double.MAX_VALUE);
        this.killMinionOnWitherDeathConfig = Config.builder.comment("Wither Minions will die when the Wither that spawned them dies.").define("Kill Minions on Wither Death", this.killMinionOnWitherDeath);
        Config.builder.push("Equipment");
        this.hasSwordConfig = Config.builder.comment("Wither Minions will spawn with a Stone Sword").define("Has Sword", this.hasSword);
        this.preHalfHealthBowChanceConfig = Config.builder.comment("Chance for the Wither Minion to spawn with a bow when Wither's above Half Health").defineInRange("Bow Chance Over Half Health", this.preHalfHealthBowChance, 0.0, 1.0);
        this.halfHealthBowChanceConfig = Config.builder.comment("Chance for the Wither Minion to spawn with a bow when Wither's below Half Health").defineInRange("Bow Chance Below Half Health", this.halfHealthBowChance, 0.0, 1.0);
        this.powerSharpnessChanceConfig = Config.builder.comment("Chance (per difficulty) for the Wither Minion Sword / Bow to be enchanted with Sharpness / Power. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining chance dictates if one more level will be added.").defineInRange("Power / Sharpness Chance", this.powerSharpnessChance, 0.0, Double.MAX_VALUE);
        this.punchKnockbackChanceConfig = Config.builder.comment("Chance (per difficulty) for the Wither Minion Sword / Bow to be enchanted with Knockback / Punch. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining chance dictates if one more level will be added.").defineInRange("Punch / Knockback Chance", this.punchKnockbackChance, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.minionAtDifficulty = (Integer)this.minionAtDifficultyConfig.get();
        this.bonusMinionEveryDifficulty = (Integer)this.bonusMinionEveryDifficultyConfig.get();
        this.maxSpawned = (Integer)this.maxSpawnedConfig.get();
        this.maxAround = (Integer)this.maxAroundConfig.get();
        this.minCooldown = (Integer)this.minCooldownConfig.get();
        this.maxCooldown = (Integer)this.maxCooldownConfig.get();
        if (this.minCooldown > this.maxCooldown) {
            this.minCooldown = this.maxCooldown;
        }
        this.cooldownMultiplierBelowHalfHealth = (Double)this.cooldownMultiplierBelowHalfHealthConfig.get();
        this.bonusSpeedPerDifficulty = (Double)this.bonusSpeedPerDifficultyConfig.get();
        this.killMinionOnWitherDeath = (Boolean)this.killMinionOnWitherDeathConfig.get();
        this.hasSword = (Boolean)this.hasSwordConfig.get();
        this.preHalfHealthBowChance = (Double)this.preHalfHealthBowChanceConfig.get();
        this.halfHealthBowChance = (Double)this.halfHealthBowChanceConfig.get();
        this.powerSharpnessChance = (Double)this.powerSharpnessChanceConfig.get();
        this.punchKnockbackChance = (Double)this.punchKnockbackChanceConfig.get();
    }

    @SubscribeEvent
    public void onWitherSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT witherTags = wither.getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt((Random)wither.field_70170_p.field_73012_v, (int)this.minCooldown, (int)this.maxCooldown) * this.cooldownMultiplierBelowHalfHealth);
        witherTags.func_74768_a("progressivebosses:wither_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingUpdateEvent event) {
        BlockPos pos2;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        WitherEntity wither = (WitherEntity)event.getEntity();
        CompoundNBT witherTags = wither.getPersistentData();
        float difficulty = witherTags.func_74760_g("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (wither.func_110143_aJ() <= 0.0f) {
            return;
        }
        if (wither.func_82212_n() > 0) {
            return;
        }
        int cooldown = witherTags.func_74762_e("progressivebosses:wither_minion_cooldown");
        if (cooldown > 0) {
            witherTags.func_74768_a("progressivebosses:wither_minion_cooldown", cooldown - 1);
            return;
        }
        int radius = 32;
        BlockPos pos1 = wither.func_233580_cy_().func_177982_a(-radius, -radius, -radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2 = wither.func_233580_cy_().func_177982_a(radius, radius, radius));
        List players = world.func_225317_b(ServerPlayerEntity.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.func_225317_b(WitherMinionEntity.class, wither.func_174813_aQ().func_186662_g(16.0));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= this.maxAround) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt((Random)world.field_73012_v, (int)minCooldown, (int)maxCooldown);
        if (wither.func_225509_J__()) {
            cooldown = (int)((double)cooldown * this.cooldownMultiplierBelowHalfHealth);
        }
        witherTags.func_74768_a("progressivebosses:wither_minion_cooldown", cooldown - 1);
        int minionSpawnedCount = 0;
        int i = this.minionAtDifficulty;
        while ((float)i <= difficulty) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (int t = 0; t < 5; ++t) {
                x = (int)(wither.func_226277_ct_() + (double)RandomHelper.getInt((Random)world.field_73012_v, (int)-3, (int)3));
                y = (int)(wither.func_226278_cu_() + 3.0);
                z = (int)(wither.func_226281_cx_() + (double)RandomHelper.getInt((Random)world.field_73012_v, (int)-3, (int)3));
                y = MinionFeature.getYSpawn((EntityType)PBEntities.WITHER_MINION.get(), new BlockPos(x, y, z), world, 8);
                if (y != -1) break;
            }
            if (y > 0) {
                WitherMinionEntity witherMinion = this.summonMinion(world, new Vector3d((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), difficulty, wither.func_225509_J__());
                ListNBT minionsList = witherTags.func_150295_c("progressivebosses:minions", 10);
                CompoundNBT uuid = new CompoundNBT();
                uuid.func_186854_a("uuid", witherMinion.func_110124_au());
                minionsList.add((Object)uuid);
                witherTags.func_218657_a("progressivebosses:minions", (INBT)minionsList);
                if (++minionSpawnedCount >= this.maxSpawned || ++minionsCountInAABB >= this.maxAround) break;
            }
            i += this.bonusMinionEveryDifficulty;
        }
    }

    @SubscribeEvent
    public void onMinionDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.magicDamageMultiplier == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof WitherMinionEntity)) {
            return;
        }
        if (event.getSource().func_82725_o()) {
            event.setAmount((float)((double)event.getAmount() * this.magicDamageMultiplier));
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.killMinionOnWitherDeath) {
            return;
        }
        if (!(event.getEntity() instanceof WitherEntity)) {
            return;
        }
        WitherEntity wither = (WitherEntity)event.getEntity();
        ServerWorld world = (ServerWorld)wither.field_70170_p;
        CompoundNBT tags = wither.getPersistentData();
        ListNBT minionsList = tags.func_150295_c("progressivebosses:minions", 10);
        for (int i = 0; i < minionsList.size(); ++i) {
            UUID uuid = minionsList.func_150305_b(i).func_186857_a("uuid");
            WitherMinionEntity witherMinionEntity = (WitherMinionEntity)world.func_217461_a(uuid);
            if (witherMinionEntity == null) continue;
            witherMinionEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, 10000, 0, false, false));
        }
    }

    private void setEquipment(WitherMinionEntity witherMinionEntity, float difficulty, boolean isCharged) {
        witherMinionEntity.func_184642_a(EquipmentSlotType.MAINHAND, Float.MIN_VALUE);
        int powerSharpnessLevel = (int)(this.powerSharpnessChance * (double)difficulty);
        if (RandomHelper.getDouble((Random)witherMinionEntity.field_70170_p.func_201674_k(), (double)0.0, (double)1.0) < this.powerSharpnessChance * (double)difficulty - (double)powerSharpnessLevel) {
            ++powerSharpnessLevel;
        }
        int punchKnockbackLevel = (int)(this.punchKnockbackChance * (double)difficulty);
        if (RandomHelper.getDouble((Random)witherMinionEntity.field_70170_p.func_201674_k(), (double)0.0, (double)1.0) < this.punchKnockbackChance * (double)difficulty - (double)punchKnockbackLevel) {
            ++punchKnockbackLevel;
        }
        ItemStack sword = new ItemStack((IItemProvider)Items.field_151052_q);
        if (powerSharpnessLevel > 0) {
            sword.func_77966_a(Enchantments.field_185302_k, powerSharpnessLevel);
        }
        if (punchKnockbackLevel > 0) {
            sword.func_77966_a(Enchantments.field_180313_o, punchKnockbackLevel);
        }
        if (this.hasSword) {
            witherMinionEntity.func_184201_a(EquipmentSlotType.MAINHAND, sword);
        }
        ItemStack bow = new ItemStack((IItemProvider)Items.field_151031_f);
        if (powerSharpnessLevel > 0) {
            bow.func_77966_a(Enchantments.field_185309_u, powerSharpnessLevel);
        }
        if (punchKnockbackLevel > 0) {
            bow.func_77966_a(Enchantments.field_185309_u, punchKnockbackLevel);
        }
        if (isCharged) {
            if (RandomHelper.getDouble((Random)witherMinionEntity.field_70170_p.func_201674_k(), (double)0.0, (double)1.0) < this.halfHealthBowChance) {
                witherMinionEntity.func_184201_a(EquipmentSlotType.MAINHAND, bow);
            }
        } else if (RandomHelper.getDouble((Random)witherMinionEntity.field_70170_p.func_201674_k(), (double)0.0, (double)1.0) < this.preHalfHealthBowChance) {
            witherMinionEntity.func_184201_a(EquipmentSlotType.MAINHAND, bow);
        }
    }

    private static int getYSpawn(EntityType entityType, BlockPos pos, World world, int minRelativeY) {
        int height = (int)Math.ceil(entityType.func_220344_i());
        int fittingYPos = -1;
        for (int y = pos.func_177956_o(); y > pos.func_177956_o() - minRelativeY; --y) {
            boolean viable = true;
            BlockPos p = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            for (int i = 0; i < height; ++i) {
                if (!world.func_180495_p(p.func_177981_b(i)).func_185904_a().func_76230_c()) continue;
                viable = false;
                break;
            }
            if (!viable) continue;
            fittingYPos = y;
            if (!world.func_180495_p(p.func_177977_b()).func_185904_a().func_76230_c()) continue;
            return y;
        }
        return fittingYPos;
    }

    public WitherMinionEntity summonMinion(World world, Vector3d pos, float difficulty, boolean isCharged) {
        WitherMinionEntity witherMinion = new WitherMinionEntity((EntityType<? extends AbstractSkeletonEntity>)((EntityType)PBEntities.WITHER_MINION.get()), world);
        CompoundNBT minionTags = witherMinion.getPersistentData();
        minionTags.func_74757_a("mobspropertiesrandomness:processed", true);
        witherMinion.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.setEquipment(witherMinion, difficulty, isCharged);
        witherMinion.func_110163_bv();
        double speedBonus = this.bonusSpeedPerDifficulty * (double)difficulty;
        MCUtils.applyModifier((LivingEntity)witherMinion, (Attribute)Attributes.field_233821_d_, (UUID)Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, (String)"progressivebosses:movement_speed_bonus", (double)speedBonus, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        MCUtils.applyModifier((LivingEntity)witherMinion, (Attribute)Attributes.field_233819_b_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)16.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        MCUtils.applyModifier((LivingEntity)witherMinion, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, (String)"progressivebosses:swim_speed_bonus", (double)2.0, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        world.func_217376_c((Entity)witherMinion);
        return witherMinion;
    }
}

