/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.progressivebosses.setup.PBLoot;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RandomChanceWithDifficultyCondition
implements LootItemCondition {
    final float chance;
    final int difficultyModifier;

    RandomChanceWithDifficultyCondition(float chance, int difficultyModifier) {
        this.chance = chance;
        this.difficultyModifier = difficultyModifier;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)PBLoot.RANDOM_CHANCE_WITH_DIFFICULTY.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)entity;
        if (!mob.getPersistentData().m_128441_("progressivebosses:difficulty")) {
            return false;
        }
        float difficulty = mob.getPersistentData().m_128457_("progressivebosses:difficulty");
        return lootContext.m_230907_().m_188501_() < this.chance * (difficulty + (float)this.difficultyModifier);
    }

    public static LootItemCondition.Builder randomChanceWithDifficulty(float chance, int difficultyModifier) {
        return () -> new RandomChanceWithDifficultyCondition(chance, difficultyModifier);
    }

    public static LootItemCondition.Builder randomChanceWithDifficulty(float chance) {
        return () -> new RandomChanceWithDifficultyCondition(chance, 0);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<RandomChanceWithDifficultyCondition> {
        public void serialize(JsonObject jsonObject, RandomChanceWithDifficultyCondition randomChanceWithDifficultyCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("chance", (Number)Float.valueOf(randomChanceWithDifficultyCondition.chance));
            jsonObject.addProperty("difficulty_modifier", (Number)randomChanceWithDifficultyCondition.difficultyModifier);
        }

        public RandomChanceWithDifficultyCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new RandomChanceWithDifficultyCondition(GsonHelper.m_13915_((JsonObject)jsonObject, (String)"chance"), GsonHelper.m_13824_((JsonObject)jsonObject, (String)"difficulty_modifier", (int)0));
        }
    }
}

