/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
@LoadFeature(module="progressivebosses:wither")
public class ResistancesFeature
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Melee Damage reduction above half health", description="Percentage Melee Damage Reduction (at max difficulty) while the Wither is above half health.")
    public static Double meleeDamageReductionAboveHalfHealth = 0.24;
    @Config(min=0.0, max=1.0)
    @Label(name="Max Melee Damage reduction before half health", description="Cap for 'Melee Damage reduction above half health'")
    public static Double maxMeleeDamageReductionAboveHalfHealth = 0.24;
    @Config(min=0.0, max=1.0)
    @Label(name="Melee Damage reduction below half health", description="Percentage Melee Damage Reduction (at max difficulty) as the Wither drops below half health.")
    public static Double meleeDamageReductionBelowHalfHealth = 0.48;
    @Config(min=0.0, max=1.0)
    @Label(name="Max Melee Damage reduction below half health", description="Cap for 'Melee Damage Reduction below half health'")
    public static Double maxMeleeDamageReductionBelowHalfHealth = 0.48;
    @Config(min=0.0, max=1024.0)
    @Label(name="Magic Damage Bonus", description="Bonus magic damage based off missing health. 250 means that every 250 missing health the damage will be amplified by 100%. E.g. The first Wither (with 300 max health) is at 50 health (so it's missing 250hp), on magic damage he will receive 'magic_damage * (missing_health / magic_damage_bonus + 1)' = 'magic_damage * (250 / 250 + 1)' = 'magic_damage * 2'.")
    public static Double magicDamageBonus = 250.0;

    public ResistancesFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onWitherDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        if (!(meleeDamageReductionBelowHalfHealth != 0.0 && maxMeleeDamageReductionBelowHalfHealth != 0.0 || meleeDamageReductionAboveHalfHealth != 0.0 && maxMeleeDamageReductionAboveHalfHealth != 0.0 || magicDamageBonus != 0.0)) {
            return;
        }
        if ((event.getSource().m_276093_(DamageTypes.f_268515_) || event.getSource().m_276093_(DamageTypes.f_268530_)) && magicDamageBonus > 0.0) {
            double missingHealth = wither.m_21233_() - wither.m_21223_();
            event.setAmount(event.getAmount() * (float)(missingHealth / magicDamageBonus + 1.0));
        }
        if (event.getSource().m_7640_() != event.getSource().m_7639_()) {
            return;
        }
        float damageReduction = !wither.m_7090_() ? (float)Math.min(maxMeleeDamageReductionAboveHalfHealth, meleeDamageReductionAboveHalfHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither)) : (float)Math.min(maxMeleeDamageReductionBelowHalfHealth, meleeDamageReductionBelowHalfHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither));
        if ((double)damageReduction == 0.0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

