/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import insane96mcp.progressivebosses.capability.Difficulty;
import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.entity.PBWither;
import insane96mcp.progressivebosses.setup.PBEntities;
import insane96mcp.progressivebosses.utils.LvlHelper;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PBCommand {
    private PBCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pb").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").then(Commands.m_82127_((String)"wither").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"lvl", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), (EntityType<? extends LivingEntity>)((EntityType)PBEntities.WITHER.get()), IntegerArgumentType.getInteger((CommandContext)context, (String)"lvl"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"))))).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), (EntityType<? extends LivingEntity>)((EntityType)PBEntities.WITHER.get()), IntegerArgumentType.getInteger((CommandContext)context, (String)"lvl")))))).then(Commands.m_82127_((String)"wither_minion").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"lvl", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), (EntityType<? extends LivingEntity>)((EntityType)PBEntities.WITHER_MINION.get()), IntegerArgumentType.getInteger((CommandContext)context, (String)"lvl"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"))))).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), (EntityType<? extends LivingEntity>)((EntityType)PBEntities.WITHER_MINION.get()), IntegerArgumentType.getInteger((CommandContext)context, (String)"lvl"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"wither").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82127_((String)"charging").executes(context -> PBCommand.witherCharge((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))).then(Commands.m_82127_((String)"barraging").executes(context -> PBCommand.witherBarrage((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))))));
    }

    private static int summon(CommandSourceStack source, EntityType<? extends LivingEntity> entityType, int lvl) {
        return PBCommand.summon(source, entityType, lvl, source.m_81371_());
    }

    private static int summon(CommandSourceStack source, EntityType<? extends LivingEntity> entityType, int lvl, Vec3 pos) {
        LivingEntity entity = (LivingEntity)entityType.m_20615_((Level)source.m_81372_());
        if (entity == null) {
            source.m_81352_((Component)Component.m_237110_((String)"progressivebosses:command.failed_to_summon", (Object[])new Object[]{entityType}));
            return 0;
        }
        LvlHelper.setLvl(entity, lvl);
        entity.m_146884_(pos);
        if (source.m_81372_().m_7967_((Entity)entity)) {
            source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.summoned_entity", (Object[])new Object[]{entity.m_5446_(), lvl}), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237110_((String)"progressivebosses:command.failed_to_summon", (Object[])new Object[]{entityType}));
        return 0;
    }

    private static int witherCharge(CommandSourceStack source, Collection<? extends Entity> pTargets) {
        int setToCharge = 0;
        for (Entity entity : pTargets) {
            PBWither pbWither;
            if (!(entity instanceof PBWither) || !(pbWither = (PBWither)entity).initCharging(WitherChargeAttackGoal.ChargeType.ON_HIT)) continue;
            ++setToCharge;
        }
        return setToCharge;
    }

    private static int witherBarrage(CommandSourceStack source, Collection<? extends Entity> pTargets) {
        int setToBarrage = 0;
        for (Entity entity : pTargets) {
            PBWither pbWither;
            if (!(entity instanceof PBWither) || !(pbWither = (PBWither)entity).initBarrageChargeUp()) continue;
            ++setToBarrage;
        }
        return setToBarrage;
    }

    private static int setBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss, int amount) {
        if (boss.equals("wither")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> difficulty.setSpawnedWithers(amount));
        }
        if (boss.equals("dragon")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> difficulty.setKilledDragons(amount));
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_set_boss_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), boss, amount}), true);
        return amount;
    }

    private static int addBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss, int amount) {
        AtomicInteger difficulty = new AtomicInteger(0);
        if (boss.equals("wither")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> {
                difficultyCap.addSpawnedWithers(amount);
                difficulty.set(difficultyCap.getSpawnedWithers());
            });
        } else if (boss.equals("dragon")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> {
                difficultyCap.addKilledDragons(amount);
                difficulty.set(difficultyCap.getKilledDragons());
            });
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_add_boss_difficulty", (Object[])new Object[]{amount, boss, targetPlayer.m_7755_(), difficulty.get()}), true);
        return difficulty.get();
    }

    private static int getBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss) {
        AtomicInteger witherDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> witherDifficulty.set(difficultyCap.getSpawnedWithers()));
        AtomicInteger dragonDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> dragonDifficulty.set(difficultyCap.getKilledDragons()));
        switch (boss) {
            case "wither": {
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_wither_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), witherDifficulty}), true);
                return witherDifficulty.get();
            }
            case "dragon": {
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_dragon_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), dragonDifficulty}), true);
                return dragonDifficulty.get();
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_wither_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), witherDifficulty}), true);
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_dragon_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), dragonDifficulty}), true);
        return 1;
    }
}

