/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.progressivebosses.setup.PBLoot;
import insane96mcp.progressivebosses.utils.LvlHelper;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class LvlCondition
implements LootItemCondition {
    final LootContext.EntityTarget entityTarget;
    final IntRange lvl;

    LvlCondition(LootContext.EntityTarget entityTarget, IntRange lvl) {
        this.entityTarget = entityTarget;
        this.lvl = lvl;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)PBLoot.LVL.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_78953_(this.entityTarget.m_79003_());
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)entity;
        if (!mob.getPersistentData().m_128441_("progressivebosses:difficulty")) {
            return false;
        }
        float lvl = LvlHelper.getLvl((LivingEntity)mob);
        return this.lvl.m_165028_(lootContext, (int)lvl);
    }

    public static LootItemCondition.Builder withLvl(LootContext.EntityTarget entityTarget, IntRange lvl) {
        return () -> new LvlCondition(entityTarget, lvl);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LvlCondition> {
        public void serialize(JsonObject jsonObject, LvlCondition lvlCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("entity", jsonSerializationContext.serialize((Object)lvlCondition.entityTarget));
            jsonObject.add("lvl", jsonSerializationContext.serialize((Object)lvlCondition.lvl));
        }

        public LvlCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            IntRange intRange = (IntRange)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"lvl", (JsonDeserializationContext)jsonDeserializationContext, IntRange.class);
            return new LvlCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)jsonObject, (String)"entity", (JsonDeserializationContext)jsonDeserializationContext, LootContext.EntityTarget.class), intRange);
        }
    }
}

