/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import com.google.common.util.concurrent.AtomicDouble;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.progressivebosses.capability.Difficulty;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Dragon.")
@LoadFeature(module="progressivebosses:ender_dragon", canBeDisabled=false)
public class DifficultyFeature
extends Feature {
    @Config(min=1.0)
    @Label(name="Max Difficulty", description="The Maximum difficulty (times killed) reachable by Ender Dragon. By default is set to 24 because it's the last spawning end gate.")
    public static Integer maxDifficulty = 8;
    @Config(min=0.0)
    @Label(name="Starting Difficulty", description="How much difficulty will players start with when joining a world? Note that this will apply when the player joins the world if the current player difficulty is below this value.")
    public static Integer startingDifficulty = 0;
    @Config
    @Label(name="Sum Killed Dragons Difficulty", description="If false and there's more than 1 player around the Dragon, difficulty will be the average of all the players' difficulty instead of summing them.")
    public static Boolean sumKilledDragonDifficulty = false;
    @Config(min=0.0)
    @Label(name="Bonus Difficulty per Player", description="Percentage bonus difficulty added to the Dragon when more than one player is present. Each player past the first one will add this percentage to the difficulty.")
    public static Double bonusDifficultyPerPlayer = 0.25;
    @Config
    @Label(name="Show First Killed Dragon Message", description="Set to false to disable the first Dragon killed message.")
    public static Boolean showFirstKilledDragonMessage = true;

    public DifficultyFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinLevelEvent event) {
        EnderDragon dragon;
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon) || (dragon = (EnderDragon)entity).m_31158_() == null) {
            return;
        }
        CompoundTag dragonTags = dragon.getPersistentData();
        if (dragonTags.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = event.getLevel().m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            return;
        }
        AtomicInteger playersFirstDragon = new AtomicInteger(0);
        AtomicDouble dragonDifficulty = new AtomicDouble(0.0);
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                dragonDifficulty.addAndGet((double)difficulty.getKilledDragons());
                if (difficulty.getFirstDragon() == 1) {
                    playersFirstDragon.incrementAndGet();
                    difficulty.setFirstDragon((byte)2);
                }
            });
        }
        dragonTags.m_128405_("progressivebosses:eggs_to_drop", playersFirstDragon.get());
        if (!sumKilledDragonDifficulty.booleanValue()) {
            dragonDifficulty.set(dragonDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            dragonDifficulty.set(dragonDifficulty.get() * (1.0 + (double)(players.size() - 1) * bonusDifficultyPerPlayer));
        }
        dragonTags.m_128350_("progressivebosses:difficulty", (float)dragonDifficulty.get());
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        int radius = 256;
        BlockPos pos1 = new BlockPos(-radius, -radius, -radius);
        BlockPos pos2 = new BlockPos(radius, radius, radius);
        AABB bb = new AABB(pos1, pos2);
        List players = dragon.m_9236_().m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            ServerPlayer nearestPlayer = (ServerPlayer)dragon.m_9236_().m_45924_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), Double.MAX_VALUE, true);
            players.add(nearestPlayer);
        }
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                if (difficulty.getKilledDragons() <= startingDifficulty && showFirstKilledDragonMessage.booleanValue()) {
                    player.m_213846_((Component)Component.m_237115_((String)"dragon.first_killed"));
                }
                if (difficulty.getKilledDragons() < maxDifficulty) {
                    difficulty.addKilledDragons(1);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
            if (difficulty.getKilledDragons() < startingDifficulty) {
                difficulty.setKilledDragons(startingDifficulty);
                LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", (Object[])new Object[]{player.m_7755_().getString()});
            }
            if (difficulty.getKilledDragons() > maxDifficulty) {
                difficulty.setKilledDragons(maxDifficulty);
                LogHelper.info((String)"[Progressive Bosses] %s killed dragons counter was above the 'Max Difficulty', Has been decreased to match 'Max Difficulty'", (Object[])new Object[]{player.m_7755_().getString()});
            }
            if (difficulty.getFirstDragon() == 0) {
                difficulty.setFirstDragon((byte)1);
                LogHelper.info((String)"[Progressive Bosses] %s first spawned. Set First Dragon to 1", (Object[])new Object[]{player.m_7755_().getString()});
            }
        });
    }
}

