/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.ai.ILNearestAttackableTargetGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.module.dragon.ai.DragonMinionAttackGoal;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import insane96mcp.progressivebosses.utils.DragonMinionHelper;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Minions", description="Shulkers that will make you float around.")
@LoadFeature(module="progressivebosses:ender_dragon")
public class MinionFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Minion at Difficulty", description="At which difficulty the Ender Dragon starts spawning Minions")
    public static Integer minionAtDifficulty = 1;
    @Config(min=0.0)
    @Label(name="Minimum Cooldown", description="Minimum ticks (20 ticks = 1 seconds) after Minions can spawn")
    public static Integer minCooldown = 1400;
    @Config(min=0.0)
    @Label(name="Maximum Cooldown", description="Maximum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    public static Integer maxCooldown = 2000;
    @Config(min=0.0, max=1.0)
    @Label(name="Cooldown Reduction", description="Percentage cooldown reduction at max difficulty for the cooldown of Minion spawning.")
    public static Double cooldownReduction = 0.4;
    @Config(min=0.0, max=1.0)
    @Label(name="Blinding Chance", description="Percentage chance at max difficulty for a Minion to spawn as a Blinding Minion.")
    public static Double blindingChance = 0.4;
    @Config(min=0.0, max=1200.0)
    @Label(name="Blinding duration", description="Time (in ticks) for the blinding effect when hit by a blinding bullet.")
    public static Integer blindingDuration = 150;
    @Config(min=0.0)
    @Label(name="Reduced Dragon Damage", description="If true, Dragon Minions will take only 10% damage from the Ender Dragon.")
    public static Boolean reducedDragonDamage = true;

    public MinionFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (minCooldown > maxCooldown) {
            minCooldown = maxCooldown;
        }
    }

    @SubscribeEvent
    public void onDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)entity;
        CompoundTag dragonTags = dragon.getPersistentData();
        int cooldown = (int)((double)Mth.m_216271_((RandomSource)dragon.m_217043_(), (int)minCooldown, (int)maxCooldown) * 0.5);
        dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown);
    }

    @SubscribeEvent
    public void onShulkerSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)entity;
        CompoundTag tags = shulker.getPersistentData();
        if (!tags.m_128441_("progressivebosses:dragon_minion")) {
            return;
        }
        MinionFeature.setMinionAI(shulker);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().m_9236_().f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        Level world = event.getEntity().m_9236_();
        CompoundTag dragonTags = dragon.getPersistentData();
        float difficulty = dragonTags.m_128457_("progressivebosses:difficulty");
        if (difficulty < (float)minionAtDifficulty.intValue() || dragon.m_21223_() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.m_128451_("progressivebosses:dragon_minion_cooldown");
        if (cooldown > 0) {
            dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown - 1);
            return;
        }
        BlockPos centerPodium = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        List players = world.m_45976_(ServerPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        cooldown = Mth.m_216271_((RandomSource)world.f_46441_, (int)minCooldown, (int)maxCooldown);
        cooldown = (int)((double)cooldown * (1.0 - cooldownReduction * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)));
        dragonTags.m_128405_("progressivebosses:dragon_minion_cooldown", cooldown - 1);
        float angle = world.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        float x = (float)(Math.cos(angle) * (double)Mth.m_216267_((RandomSource)dragon.m_217043_(), (float)16.0f, (float)40.0f));
        float z = (float)(Math.sin(angle) * (double)Mth.m_216267_((RandomSource)dragon.m_217043_(), (float)16.0f, (float)40.0f));
        float y = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, BlockPos.m_274561_((double)x, (double)255.0, (double)z)).m_123342_();
        MinionFeature.summonMinion(world, new Vec3((double)x, (double)y, (double)z), DifficultyHelper.getScalingDifficulty((LivingEntity)dragon));
    }

    private static void setMinionAI(Shulker shulker) {
        ArrayList<Goal> toRemove = new ArrayList<Goal>();
        shulker.f_21345_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof Shulker.ShulkerAttackGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21345_).m_25363_(arg_0));
        shulker.f_21345_.m_25352_(2, (Goal)new DragonMinionAttackGoal(shulker, 70));
        toRemove.clear();
        shulker.f_21346_.f_25345_.forEach(goal -> {
            if (goal.m_26015_() instanceof NearestAttackableTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
            if (goal.m_26015_() instanceof HurtByTargetGoal) {
                toRemove.add(goal.m_26015_());
            }
        });
        toRemove.forEach(arg_0 -> ((GoalSelector)shulker.f_21346_).m_25363_(arg_0));
        shulker.f_21346_.m_25352_(2, (Goal)new ILNearestAttackableTargetGoal((Mob)shulker, Player.class, false).setIgnoreLineOfSight());
        shulker.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)shulker, new Class[]{Shulker.class, EnderDragon.class}));
    }

    public static void summonMinion(Level world, Vec3 pos, float scalingDifficulty) {
        Shulker shulker = (Shulker)EntityType.f_20521_.m_20615_(world);
        if (shulker == null) {
            LogHelper.warn("Failed to summon Dragon Minion", new Object[0]);
            return;
        }
        CompoundTag minionTags = shulker.getPersistentData();
        minionTags.m_128379_("progressivebosses:dragon_minion", true);
        minionTags.m_128379_("mobspropertiesrandomness:processed", true);
        boolean isBlindingMinion = world.m_213780_().m_188500_() < blindingChance * (double)scalingDifficulty;
        shulker.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        shulker.m_6593_((Component)Component.m_237115_((String)"progressivebosses:dragon_minion"));
        shulker.f_21355_ = BuiltInLootTables.f_78712_;
        shulker.m_21530_();
        DragonMinionHelper.setMinionColor(shulker, isBlindingMinion);
        MCUtils.applyModifier((LivingEntity)shulker, (Attribute)Attributes.f_22277_, (UUID)Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, (String)"progressivebosses:follow_range_bonus", (double)64.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        world.m_7967_((Entity)shulker);
    }

    @SubscribeEvent
    public void onMinionHurt(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && reducedDragonDamage.booleanValue() && (livingEntity = event.getEntity()) instanceof Shulker)) {
            return;
        }
        Shulker shulker = (Shulker)livingEntity;
        CompoundTag compoundNBT = shulker.getPersistentData();
        if (!compoundNBT.m_128441_("progressivebosses:dragon_minion")) {
            return;
        }
        if (event.getSource().m_7639_() instanceof EnderDragon) {
            event.setAmount(event.getAmount() * 0.1f);
        }
    }

    public static void onBulletTick(ShulkerBullet shulkerBulletEntity) {
        if (!shulkerBulletEntity.m_9236_().f_46443_ && shulkerBulletEntity.getPersistentData().m_128471_("progressivebosses:blindness_bullet")) {
            ((ServerLevel)shulkerBulletEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, shulkerBulletEntity.m_20185_(), shulkerBulletEntity.m_20186_(), shulkerBulletEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

