/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
@LoadFeature(module="progressivebosses:ender_dragon")
public class ResistancesFeature
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Melee Damage reduction while at the center", description="Melee Damage reduction at max difficulty while the Ender Dragon is at the center.")
    public static Double damageReductionWhenSitting = 0.24;
    @Config(min=0.0, max=1.0)
    @Label(name="Melee Damage increase while not at the center", description="Melee Damage is increased by this percentage while the Ender Dragon is not at the center.")
    public static Double damageIncreaseWhileNotSitting = 0.24;
    @Config(min=0.0, max=1.0)
    @Label(name="Explosion Damage reduction", description="Damage reduction when hit by explosions (firework rockets excluded).")
    public static Double explosionDamageReduction = 0.667;
    private static final List<EnderDragonPhase<? extends DragonPhaseInstance>> sittingPhases = Arrays.asList(EnderDragonPhase.f_31383_, EnderDragonPhase.f_31384_, EnderDragonPhase.f_31382_, EnderDragonPhase.f_31381_);

    public ResistancesFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onDragonDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        ResistancesFeature.meleeDamageReduction(event, dragon);
        ResistancesFeature.meleeDamageIncrease(event, dragon);
        ResistancesFeature.explosionDamageReduction(event, dragon);
    }

    private static void meleeDamageReduction(LivingDamageEvent event, EnderDragon dragon) {
        if (damageReductionWhenSitting == 0.0) {
            return;
        }
        if (sittingPhases.contains(dragon.m_31157_().m_31415_().m_7309_()) && event.getSource().m_7640_() instanceof Player) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * (damageReductionWhenSitting * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon))));
        }
    }

    private static void meleeDamageIncrease(LivingDamageEvent event, EnderDragon dragon) {
        if (damageIncreaseWhileNotSitting == 0.0) {
            return;
        }
        if (!sittingPhases.contains(dragon.m_31157_().m_31415_().m_7309_()) && event.getSource().m_7640_() instanceof Player) {
            event.setAmount(event.getAmount() + (float)((double)event.getAmount() * (damageIncreaseWhileNotSitting * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon))));
        }
    }

    private static void explosionDamageReduction(LivingDamageEvent event, EnderDragon dragon) {
        if (explosionDamageReduction == 0.0) {
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268415_) && !event.getSource().m_19385_().equals("fireworks")) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * explosionDamageReduction));
        }
    }
}

