/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.data.JsonFeatureDataReloadListener;
import insane96mcp.insanelib.network.JsonConfigSyncMessage;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.util.TagUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;

public abstract class JsonFeature
extends Feature {
    public final List<JsonConfig<?>> JSON_CONFIGS = new ArrayList();
    private static final HashMap<ResourceLocation, SyncType> SYNC_TYPE_REGISTRY = new HashMap();

    public JsonFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        JsonFeatureDataReloadListener.INSTANCE.registerJsonConfigFeature(this);
    }

    public abstract String getModConfigFolder();

    public void loadJsonConfigs() {
        if (!this.isEnabled()) {
            return;
        }
        File jsonConfigFolder = new File(this.getModConfigFolder() + "/" + this.getModule().getName() + "/" + this.getName());
        if (!jsonConfigFolder.exists() && !jsonConfigFolder.mkdirs()) {
            LogHelper.warn("Failed to create %s json config folder", this.getName());
        }
        for (JsonConfig<?> jsonConfig : this.JSON_CONFIGS) {
            jsonConfig.loadAndReadFile(jsonConfigFolder);
        }
    }

    protected static <T> void loadAndReadJson(String json, List<T> list, List<T> defaultList, Type listType) {
        ArrayList<T> listRead;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        list.clear();
        try {
            listRead = (ArrayList<T>)gson.fromJson(json, listType);
        }
        catch (Exception e) {
            listRead = new ArrayList<T>(defaultList);
        }
        list.addAll(listRead);
    }

    public static boolean isItemInTag(Item item, ResourceLocation tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isItemInTag(item, tag);
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tagKey);
        for (Holder holder : tags) {
            if (!((Item)holder.m_203334_()).equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemInTag(Item item, TagKey<Item> tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isItemInTag(item, tag);
        }
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tag);
        for (Holder holder : tags) {
            if (!((Item)holder.m_203334_()).equals(item)) continue;
            return true;
        }
        return false;
    }

    public static List<Item> getAllItems(IdTagMatcher idTagMatcher, boolean isClientSide) {
        if (idTagMatcher.type == IdTagMatcher.Type.ID || isClientSide) {
            return idTagMatcher.getAllItems();
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)idTagMatcher.location);
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tagKey);
        ArrayList<Item> list = new ArrayList<Item>();
        for (Holder holder : tags) {
            list.add((Item)holder.m_203334_());
        }
        return list;
    }

    public static boolean isBlockInTag(Block block, ResourceLocation tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isBlockInTag(block, tag);
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag);
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tagKey);
        for (Holder holder : tags) {
            if (!((Block)holder.m_203334_()).equals(block)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockInTag(Block block, TagKey<Block> tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isBlockInTag(block, tag);
        }
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tag);
        for (Holder holder : tags) {
            if (!((Block)holder.m_203334_()).equals(block)) continue;
            return true;
        }
        return false;
    }

    public static List<Block> getAllBlocks(IdTagMatcher idTagMatcher, boolean isClientSide) {
        if (idTagMatcher.type == IdTagMatcher.Type.ID || isClientSide) {
            return idTagMatcher.getAllBlocks();
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)idTagMatcher.location);
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tagKey);
        ArrayList<Block> list = new ArrayList<Block>();
        for (Holder holder : tags) {
            list.add((Block)holder.m_203334_());
        }
        return list;
    }

    public static boolean isEntityInTag(Entity entity, ResourceLocation tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isEntityInTag(entity, tag);
        }
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tag);
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tagKey);
        for (Holder holder : tags) {
            if (!((EntityType)holder.m_203334_()).equals(entity.m_6095_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityInTag(Entity entity, TagKey<EntityType<?>> tag, boolean isClientSide) {
        if (isClientSide) {
            return TagUtils.isEntityInTag(entity, tag);
        }
        Collection tags = JsonFeatureDataReloadListener.reloadContext.getTag(tag);
        for (Holder holder : tags) {
            if (!((EntityType)holder.m_203334_()).equals(entity.m_6095_())) continue;
            return true;
        }
        return false;
    }

    public static void addSyncType(ResourceLocation id, SyncType syncType) {
        SYNC_TYPE_REGISTRY.put(id, syncType);
    }

    @Nullable
    public static SyncType getSyncType(ResourceLocation id) {
        return SYNC_TYPE_REGISTRY.get(id);
    }

    @SubscribeEvent
    public void onDataPackSync(OnDatapackSyncEvent event) {
        for (JsonConfig<?> jsonConfig : this.JSON_CONFIGS) {
            jsonConfig.syncToClient(event);
        }
    }

    @SubscribeEvent
    public void onTagsUpdatedEvent(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            for (JsonConfig<?> jsonConfig : this.JSON_CONFIGS) {
                jsonConfig.onLoad(true);
            }
        }
    }

    public static class JsonConfig<T> {
        String fileName;
        List<T> list;
        List<T> defaultList;
        Type listType;
        @Nullable
        BiConsumer<List<T>, Boolean> onLoad;
        boolean syncToClient;
        @Nullable
        ResourceLocation syncType;

        public JsonConfig(String fileName, List<T> list, List<T> defaultList, Type listType, @Nullable BiConsumer<List<T>, Boolean> onLoad, boolean syncToClient, ResourceLocation syncType) {
            this.fileName = fileName;
            this.list = list;
            this.defaultList = defaultList;
            this.listType = listType;
            this.onLoad = onLoad;
            this.syncToClient = syncToClient;
            this.syncType = syncType;
        }

        public JsonConfig(String fileName, List<T> list, List<T> defaultList, Type listType, boolean syncToClient, ResourceLocation syncType) {
            this(fileName, list, defaultList, listType, null, syncToClient, syncType);
        }

        public JsonConfig(String fileName, List<T> list, List<T> defaultList, Type listType, BiConsumer<List<T>, Boolean> onLoad) {
            this(fileName, list, defaultList, listType, onLoad, false, null);
        }

        public JsonConfig(String fileName, List<T> list, List<T> defaultList, Type listType) {
            this(fileName, list, defaultList, listType, false, null);
        }

        protected void loadAndReadFile(File folder) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File file = new File(folder, this.fileName);
            if (!file.exists()) {
                try {
                    if (!file.createNewFile()) {
                        throw new Exception("File#createNewFile failed");
                    }
                    String json = gson.toJson(this.defaultList, this.listType);
                    Files.write(file.toPath(), json.getBytes(), new OpenOption[0]);
                }
                catch (Exception e) {
                    LogHelper.error("Failed to create default Json %s: %s", FilenameUtils.removeExtension((String)file.getName()), e.getMessage());
                }
            }
            this.list.clear();
            try {
                FileReader fileReader = new FileReader(file);
                List listRead = (List)gson.fromJson((Reader)fileReader, this.listType);
                this.list.addAll(listRead);
            }
            catch (JsonSyntaxException e) {
                LogHelper.error("Parsing error loading Json %s: %s", FilenameUtils.removeExtension((String)file.getName()), e.getMessage());
            }
            catch (Exception e) {
                LogHelper.error("Failed loading Json %s: %s", FilenameUtils.removeExtension((String)file.getName()), e.getMessage());
            }
            this.onLoad(false);
        }

        public void onLoad(boolean isClientSide) {
            if (this.onLoad != null) {
                this.onLoad.accept(this.list, isClientSide);
            }
        }

        public void syncToClient(OnDatapackSyncEvent event) {
            if (!this.syncToClient) {
                return;
            }
            Gson gson = new GsonBuilder().create();
            if (event.getPlayer() == null) {
                event.getPlayerList().m_11314_().forEach(player -> JsonConfigSyncMessage.sync(this.syncType, gson.toJson(this.list, this.listType), player));
            } else {
                JsonConfigSyncMessage.sync(this.syncType, gson.toJson(this.list, this.listType), event.getPlayer());
            }
        }
    }

    public static class SyncType {
        public Consumer<String> onSync;

        public SyncType(Consumer<String> onSync) {
            this.onSync = onSync;
        }
    }
}

