/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.base.ConfigOption;
import insane96mcp.insanelib.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

@JsonAdapter(value=Serializer.class)
public class IdTagMatcher
implements StringRepresentable {
    public Type type;
    public ResourceLocation location;
    @Nullable
    public ResourceLocation dimension;
    public static final java.lang.reflect.Type LIST_TYPE = new TypeToken<ArrayList<IdTagMatcher>>(){}.getType();

    public IdTagMatcher(Type type, ResourceLocation location, @Nullable ResourceLocation dimension) {
        Objects.requireNonNull(type, "type can't be null");
        Objects.requireNonNull(location, "location can't be null");
        this.type = type;
        this.location = location;
        this.dimension = dimension;
    }

    public IdTagMatcher(Type type, ResourceLocation location) {
        this(type, location, null);
    }

    public IdTagMatcher(Type type, String location, @Nullable String dimension) {
        this(type, new ResourceLocation(location), dimension == null ? null : new ResourceLocation(dimension));
    }

    public IdTagMatcher(Type type, String location) {
        this(type, new ResourceLocation(location), null);
    }

    public static IdTagMatcher newId(String location) {
        return IdTagMatcher.newId(location, null);
    }

    public static IdTagMatcher newId(String location, @Nullable String dimension) {
        return new IdTagMatcher(Type.ID, location, dimension);
    }

    public static IdTagMatcher newTag(String location) {
        return IdTagMatcher.newTag(location, null);
    }

    public static IdTagMatcher newTag(String location, @Nullable String dimension) {
        return new IdTagMatcher(Type.TAG, location, dimension);
    }

    @Nullable
    public static IdTagMatcher parseLine(String line) {
        String[] split = line.split(",");
        if (split.length < 1 || split.length > 2) {
            LogHelper.warn("Invalid line \"%s\". Format must be modid:entry_or_tag,modid:dimension", line);
            return null;
        }
        ResourceLocation dimension = null;
        if (split.length == 2 && (dimension = ResourceLocation.m_135820_((String)split[1])) == null) {
            LogHelper.warn(String.format("Invalid dimension. Ignoring it. '%s'", line), new Object[0]);
        }
        if (split[0].startsWith("#")) {
            ResourceLocation tag = ResourceLocation.m_135820_((String)split[0].substring(1));
            if (tag == null) {
                LogHelper.warn("Tag is not valid. '%s'", line);
                return null;
            }
            return new IdTagMatcher(Type.TAG, tag, dimension);
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)split[0]);
        if (id == null) {
            LogHelper.warn("Id is not valid. '%s'", line);
            return null;
        }
        return new IdTagMatcher(Type.ID, id, dimension);
    }

    public static ArrayList<? extends IdTagMatcher> parseStringList(List<? extends String> list) {
        ArrayList<IdTagMatcher> idTagMatchers = new ArrayList<IdTagMatcher>();
        for (String string : list) {
            IdTagMatcher idTagMatcher = IdTagMatcher.parseLine(string);
            if (idTagMatcher == null) continue;
            idTagMatchers.add(idTagMatcher);
        }
        return idTagMatchers;
    }

    public boolean matchesBlock(Block block) {
        return this.matchesBlock(block, null);
    }

    public boolean matchesBlock(Block block, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
            if (!tag.contains((Object)block)) {
                return false;
            }
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id != null && id.equals((Object)this.location)) {
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public boolean matchesBlock(BlockState state) {
        return this.matchesBlock(state.m_60734_(), null);
    }

    public boolean matchesBlock(BlockState state, @Nullable ResourceLocation dimensionId) {
        return this.matchesBlock(state.m_60734_(), dimensionId);
    }

    public boolean matchesItem(Item item) {
        return this.matchesItem(item, null);
    }

    public boolean matchesItem(Item item, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
            if (!tag.contains((Object)item)) {
                return false;
            }
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id != null && id.equals((Object)this.location)) {
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public boolean matchesItem(ItemStack stack) {
        return this.matchesItem(stack.m_41720_(), null);
    }

    public boolean matchesItem(ItemStack stack, @Nullable ResourceLocation dimensionId) {
        return this.matchesItem(stack.m_41720_(), dimensionId);
    }

    public boolean matchesFluid(Fluid fluid) {
        return this.matchesFluid(fluid, null);
    }

    public boolean matchesFluid(Fluid fluid, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)this.location);
            ITag fluidTag = ForgeRegistries.FLUIDS.tags().getTag(tagKey);
            if (!fluidTag.contains((Object)fluid)) {
                return false;
            }
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (id != null && id.equals((Object)this.location)) {
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public boolean matchesEntity(Entity entity) {
        return this.matchesEntity(entity.m_6095_(), null);
    }

    public boolean matchesEntity(Entity entity, @Nullable ResourceLocation dimensionId) {
        return this.matchesEntity(entity.m_6095_(), dimensionId);
    }

    public boolean matchesEntity(EntityType<?> entityType) {
        return this.matchesEntity(entityType, null);
    }

    public boolean matchesEntity(EntityType<?> entityType, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.ENTITY_TYPES.tags().getTag(tagKey);
            if (!tag.contains(entityType)) {
                return false;
            }
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (id != null && id.equals((Object)this.location)) {
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public boolean matchesBiome(Holder<Biome> biome) {
        return this.matchesBiome(biome, null);
    }

    public boolean matchesBiome(Holder<Biome> biome, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.location);
            return biome.m_203656_(tagKey) && (this.dimension == null || this.dimension.equals((Object)dimensionId));
        }
        return biome.m_203373_(this.location) && (this.dimension == null || this.dimension.equals((Object)dimensionId));
    }

    public boolean matchesEnchantment(Enchantment enchantment) {
        return this.matchesEnchantment(enchantment, null);
    }

    public boolean matchesEnchantment(Enchantment enchantment, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.ENCHANTMENTS.tags().getTag(tagKey);
            if (!tag.contains((Object)enchantment)) {
                return false;
            }
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (id != null && id.equals((Object)this.location)) {
            return this.dimension == null || this.dimension.equals((Object)dimensionId);
        }
        return false;
    }

    public boolean matchesDimension(ResourceLocation dimension) {
        return this.dimension == null || this.dimension.equals((Object)dimension);
    }

    public List<Block> getAllBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (this.type == Type.ID) {
            if (!ForgeRegistries.BLOCKS.containsKey(this.location)) {
                return blocks;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.location);
            if (block != null) {
                blocks.add(block);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)this.location);
            ITag blockTag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
            blocks.addAll(blockTag.stream().toList());
        }
        return blocks;
    }

    public List<Item> getAllItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.type == Type.ID) {
            if (!ForgeRegistries.ITEMS.containsKey(this.location)) {
                return items;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.location);
            if (item != null) {
                items.add(item);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.location);
            ITag itemTag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
            items.addAll(itemTag.stream().toList());
        }
        return items;
    }

    public List<ItemStack> getAllItemStacks() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        this.getAllItems().forEach(item -> itemStacks.add(new ItemStack((ItemLike)item)));
        return itemStacks;
    }

    public List<Fluid> getAllFluids() {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        if (this.type == Type.ID) {
            if (!ForgeRegistries.FLUIDS.containsKey(this.location)) {
                return fluids;
            }
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(this.location);
            if (fluid != null) {
                fluids.add(fluid);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)this.location);
            ITag fluidTag = ForgeRegistries.FLUIDS.tags().getTag(tagKey);
            fluids.addAll(fluidTag.stream().toList());
        }
        return fluids;
    }

    public List<FluidStack> getAllFluidStacks() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        this.getAllFluids().forEach(item -> fluidStacks.add(new FluidStack(item, 1000)));
        return fluidStacks;
    }

    public List<EntityType<?>> getAllEntityTypes() {
        ArrayList entityTypes = new ArrayList();
        if (this.type == Type.ID) {
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(this.location)) {
                return entityTypes;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.location);
            if (entityType != null) {
                entityTypes.add(entityType);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)this.location);
            ITag entityTag = ForgeRegistries.ENTITY_TYPES.tags().getTag(tagKey);
            entityTypes.addAll(entityTag.stream().toList());
        }
        return entityTypes;
    }

    public String m_7912_() {
        Object s = this.type == Type.TAG ? "#" : "";
        s = (String)s + this.location.toString();
        if (this.dimension != null) {
            s = (String)s + "," + this.dimension;
        }
        return s;
    }

    public String toString() {
        Object s = this.location.toString();
        if (this.type == Type.TAG) {
            s = "#" + (String)s;
        }
        if (this.dimension != null) {
            s = (String)s + " in " + this.dimension;
        }
        return s;
    }

    public static enum Type {
        ID,
        TAG;

    }

    public static class Serializer
    implements JsonDeserializer<IdTagMatcher>,
    JsonSerializer<IdTagMatcher> {
        public IdTagMatcher deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                String s = json.getAsString();
                return new IdTagMatcher(s.startsWith("#") ? Type.TAG : Type.ID, s.replace("#", ""));
            }
            String id = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"id", (String)"");
            String tag = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"tag", (String)"");
            String dimension = GsonHelper.m_13851_((JsonObject)json.getAsJsonObject(), (String)"dimension", (String)"");
            if (!id.equals("") && !ResourceLocation.m_135830_((String)id)) {
                throw new JsonParseException("Invalid id for IdTagMatcher: %s".formatted(id));
            }
            if (!tag.equals("") && !ResourceLocation.m_135830_((String)id)) {
                throw new JsonParseException("Invalid tag for IdTagMatcher: %s".formatted(tag));
            }
            if (!dimension.equals("") && !ResourceLocation.m_135830_((String)dimension)) {
                throw new JsonParseException("Invalid dimension for IdTagMatcher: %s".formatted(dimension));
            }
            if (!id.equals("") && !tag.equals("")) {
                throw new JsonParseException("Invalid IdTagMatcher containing both tag (%s) and id (%s)".formatted(tag, id));
            }
            if (!id.equals("")) {
                if (dimension.equals("")) {
                    return new IdTagMatcher(Type.ID, id);
                }
                return new IdTagMatcher(Type.ID, id, dimension);
            }
            if (!tag.equals("")) {
                if (dimension.equals("")) {
                    return new IdTagMatcher(Type.TAG, tag);
                }
                return new IdTagMatcher(Type.TAG, tag, dimension);
            }
            throw new JsonParseException("Invalid IdTagMatcher missing either tag and id");
        }

        public JsonElement serialize(IdTagMatcher src, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
            if (src.dimension == null) {
                Object ret = src.location.toString();
                if (src.type == Type.TAG) {
                    ret = "#" + (String)ret;
                }
                return new JsonPrimitive((String)ret);
            }
            JsonObject jsonObject = new JsonObject();
            if (src.type == Type.ID) {
                jsonObject.addProperty("id", src.location.toString());
            } else {
                jsonObject.addProperty("tag", src.location.toString());
            }
            jsonObject.addProperty("dimension", src.dimension.toString());
            return jsonObject;
        }
    }

    public static class Config
    extends ConfigOption<IdTagMatcher> {
        private final ForgeConfigSpec.ConfigValue<String> idTagMatcherValue;

        public Config(ForgeConfigSpec.Builder builder, String name, String description, IdTagMatcher defaultValue) {
            super(builder, name, description);
            this.idTagMatcherValue = builder.define(name, (Object)defaultValue.m_7912_());
        }

        @Override
        public IdTagMatcher get() {
            return IdTagMatcher.parseLine((String)this.idTagMatcherValue.get());
        }

        @Override
        public void set(Object value) {
            this.idTagMatcherValue.set((Object)((IdTagMatcher)value).m_7912_());
        }

        @Override
        @Nullable
        public List<String> getConfigPath() {
            return this.idTagMatcherValue.getPath();
        }
    }
}

