/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public record SerializableAttributeModifier(UUID uuid, String name, List<EquipmentSlot> slots, Supplier<Attribute> attribute, double amount, AttributeModifier.Operation operation) {
    public static final Type LIST_TYPE = new TypeToken<ArrayList<SerializableAttributeModifier>>(){}.getType();
    public static final Type LIST_TYPE_SLOT = new TypeToken<ArrayList<EquipmentSlot>>(){}.getType();

    public AttributeModifier getModifier() {
        return new AttributeModifier(this.uuid, this.name, this.amount, this.operation);
    }

    public static SerializableAttributeModifier fromNetwork(FriendlyByteBuf byteBuf) {
        UUID uuid = byteBuf.m_130259_();
        String name = byteBuf.m_130277_();
        List slots = byteBuf.m_236845_(byteBuf1 -> (EquipmentSlot)byteBuf1.m_130066_(EquipmentSlot.class));
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)byteBuf.m_130277_()));
        double amount = byteBuf.readDouble();
        Operation operation = (Operation)byteBuf.m_130066_(Operation.class);
        return new SerializableAttributeModifier(uuid, name, slots, () -> attribute, amount, operation.get());
    }

    public void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.m_130077_(this.uuid);
        byteBuf.m_130070_(this.name);
        byteBuf.m_236828_(this.slots, FriendlyByteBuf::m_130068_);
        byteBuf.m_130070_(ForgeRegistries.ATTRIBUTES.getKey((Object)this.attribute.get()).toString());
        byteBuf.writeDouble(this.amount);
        byteBuf.m_130068_((Enum)this.operation);
    }

    public static enum Operation {
        ADDITION(AttributeModifier.Operation.ADDITION, "addition"),
        MULTIPLY_BASE(AttributeModifier.Operation.MULTIPLY_BASE, "multiply_base"),
        MULTIPLY_TOTAL(AttributeModifier.Operation.MULTIPLY_TOTAL, "multiply_total");

        final AttributeModifier.Operation operation;
        final String serializedName;

        public AttributeModifier.Operation get() {
            return this.operation;
        }

        private Operation(AttributeModifier.Operation operation, String serializedName) {
            this.operation = operation;
            this.serializedName = serializedName;
        }

        @Nullable
        public static String getNameFromOperation(AttributeModifier.Operation operation) {
            for (Operation amo : Operation.values()) {
                if (amo.operation != operation) continue;
                return amo.serializedName;
            }
            return null;
        }
    }

    public static class Serializer
    implements JsonDeserializer<SerializableAttributeModifier>,
    JsonSerializer<SerializableAttributeModifier> {
        public SerializableAttributeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            UUID uuid;
            JsonObject jObject = json.getAsJsonObject();
            String sUUID = GsonHelper.m_13906_((JsonObject)jObject, (String)"uuid");
            try {
                uuid = UUID.fromString(sUUID);
            }
            catch (Exception ex) {
                throw new JsonParseException("uuid %s is not valid".formatted(sUUID));
            }
            String name = GsonHelper.m_13906_((JsonObject)jObject, (String)"name");
            ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>();
            if (jObject.has("slot")) {
                slots.add(EquipmentSlot.m_20747_((String)jObject.get("slot").getAsString()));
            } else if (jObject.has("slots")) {
                JsonArray jArraySlot = jObject.getAsJsonArray("slots");
                for (int i = 0; i < jArraySlot.size(); ++i) {
                    EquipmentSlot slot = EquipmentSlot.m_20747_((String)jArraySlot.get(i).getAsString());
                    slots.add(slot);
                }
            }
            String sAttribute = GsonHelper.m_13906_((JsonObject)jObject, (String)"attribute");
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)sAttribute));
            if (attribute == null) {
                throw new JsonParseException("Invalid attribute: %s".formatted(sAttribute));
            }
            double amount = GsonHelper.m_144784_((JsonObject)jObject, (String)"amount");
            Operation operation = (Operation)((Object)context.deserialize(jObject.get("operation"), Operation.class));
            return new SerializableAttributeModifier(uuid, name, slots, () -> attribute, amount, operation.get());
        }

        public JsonElement serialize(SerializableAttributeModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("uuid", src.uuid.toString());
            jObject.addProperty("name", src.name);
            if (src.slots.size() == 1) {
                jObject.addProperty("slot", src.slots.get(0).m_20751_());
            } else if (src.slots.size() > 1) {
                JsonArray jArraySlots = new JsonArray();
                for (EquipmentSlot equipmentSlot : src.slots) {
                    jArraySlots.add(equipmentSlot.m_20751_());
                }
                jObject.add("slots", (JsonElement)jArraySlots);
            }
            jObject.addProperty("attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)src.attribute.get()).toString());
            jObject.addProperty("amount", (Number)src.amount);
            jObject.addProperty("operation", Operation.getNameFromOperation(src.operation));
            return jObject;
        }
    }
}

