/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.utils.Drop;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

@ConfigEntries
@Label(name="Rewards", description="Bonus Experience and Drops")
public class RewardFeature
implements LabelConfigGroup {
    @ConfigEntry(translationKey="Bonus Experience per Difficulty", comment="How much more experience (percentage) will Wither drop per Difficulty. The percentage is additive (e.g. with this set to 200%, 7 withers spawned = 1400% more experience)")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusExperience = 7.5;
    @ConfigEntry(translationKey="Drops", comment="A list of drops for the Withers. Entry format: item,amount,difficulty_required,chance,difficulty_mode,chance_mode\nitem: item id\namount: amount\ndifficulty_required: the amount of difficulty required for the item to drop, works differently based on mode\nchance: chance for the drop to happen, between 0 and 1\ndifficulty_mode:\n* MINIMUM: will try to drop the item when the difficulty matches or is higher\n* PER_DIFFICULTY: will try to drop the item once per difficulty (e.g. at difficulty 10, difficulty required 3, there is the chance to drop the item, trying 7 times)\nchance_mode:\n* FLAT: chance is the percentage chance for the item to drop if the difficulty criteria matches\n* SCALING: each point of difficulty >= 'difficulty to drop the item' will be multiplied by the chance (e.g. chance 2% and difficulty 10, difficulty required 5, chance to drop the item will be chance * (difficulty - difficulty_required + 1) = 2% * (10 - 5 + 1) = 12%)\nBy default Withers have 75% chance per difficulty to drop 2 shard (So at difficulty 8, up to 16 shards can be dropped, 75% chance each 2).")
    public static List<String> dropsListConfig = Arrays.asList("progressivebosses:nether_star_shard,2,1,0.75,PER_DIFFICULTY,FLAT", "minecraft:ancient_debris,2,1,0.75,PER_DIFFICULTY,FLAT");
    @ConfigEntries.Exclude
    public ArrayList<Drop> dropsList;

    public RewardFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        this.dropsList = Drop.parseDropsList(dropsListConfig);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.DEATH.register(event -> this.onDeath(event));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (this.bonusExperience == 0.0) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = witherTags.method_10583("progressivebosses:difficulty");
        wither.field_6194 = 50 + (int)(50.0 * (this.bonusExperience * (double)difficulty));
    }

    public void onDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (this.dropsList.isEmpty()) {
            return;
        }
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_13092;
        class_2487 tags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        for (Drop drop : this.dropsList) {
            drop.drop(wither.field_6002, wither.method_19538(), difficulty);
        }
    }
}

