/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.module.Modules;
import insane96mcp.progressivebosses.module.dragon.entity.AreaEffectCloud3DEntity;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.RandomHelper;
import insane96mcp.progressivebosses.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1513;
import net.minecraft.class_1525;
import net.minecraft.class_1527;
import net.minecraft.class_1657;
import net.minecraft.class_1670;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_3033;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

@ConfigEntries(includeAll=true)
@Label(name="Attack", description="Makes the dragon hit harder in various different ways")
public class AttackFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Bonus Direct Damage", comment="How much more damage per difficulty (percentage) does the Ender Dragon (directly) deal per difficulty?")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double increasedDirectDamage = 0.3;
    @ConfigEntry(nameKey="Bonus Acid Pool Damage", comment="How much more damage per difficulty (percentage) does the Ender Dragon's Acid Pool deal per difficulty?")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double increasedAcidPoolDamage = 0.3;
    @ConfigEntry(nameKey="Charge Player Max Chance", comment="Normally the Ender Dragon attacks only when leaving the center platform. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to charge the player.\nThis is the chance to start a charge attack when the difficulty is at max. Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double chargePlayerMaxChance = 0.45;
    @ConfigEntry(nameKey="Fireball Max Chance", comment="Normally the Ender Dragon spits fireballs when a Crystal is destroyed and rarely during the fight. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to spit a fireball.\nThis is the chance to start a fireball attack when the difficulty is at max. Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double fireballMaxChance = 0.35;
    @ConfigEntry(nameKey="Increase Max Rise and Fall", comment="Since around 1.13/1.14 the Ender Dragon can no longer dive for more than about 3 blocks so she takes a lot to rise / fall. With this active the dragon will be able to rise and fall many more blocks, making easier to hit the player and approach the center.")
    public boolean increaseMaxRiseAndFall = true;
    @ConfigEntry(nameKey="Fireball Explosion Magic Damage", comment="On impact the Acid Fireball will deal magic damage in an area.")
    public boolean fireballExplosionDamages = true;
    @ConfigEntry(nameKey="Fireball 3D Area Effect Cloud", comment="On impact the Acid Fireball will generate a 3D area of effect cloud instead of a normal flat one. The 3D cloud lasts for half the time")
    public boolean fireball3DEffectCloud = true;
    @ConfigEntry(nameKey="Fireball Velocity Multiplier", comment="Speed multiplier for the Dragon Fireball.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double fireballVelocityMultiplier = 2.5;
    @ConfigEntry(nameKey="Bonus Fireballs", comment="The dragon will fire (up to) this more fireballs per difficulty. A decimal number dictates the chance to shot 1 more fireball, e.g. at difficulty 2 this value is 1.4, meaning that the dragon will can shot up to 2 fireballs and has 40% chance to shot up to 3. The bonus fireballs aren't directly aimed at the player but have.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double maxBonusFireball = 2.0;

    public AttackFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.HURT.register(event -> this.onDamageDealt(event));
    }

    public void onSpawn(DummyEvent event) {
        this.fireballSpeed(event.getEntity());
    }

    private void fireballSpeed(class_1297 entity) {
        if (!(entity instanceof class_1670)) {
            return;
        }
        class_1670 fireball = (class_1670)entity;
        if (!this.isEnabled() || this.fireballVelocityMultiplier == 0.0) {
            return;
        }
        if (Math.abs(fireball.field_7601) > 10.0 || Math.abs(fireball.field_7600) > 10.0 || Math.abs(fireball.field_7599) > 10.0) {
            entity.method_5768();
            return;
        }
        fireball.field_7601 *= this.fireballVelocityMultiplier;
        fireball.field_7600 *= this.fireballVelocityMultiplier;
        fireball.field_7599 *= this.fireballVelocityMultiplier;
    }

    public void onDamageDealt(LivingEntityEvents.OnLivingHurtEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        this.onDirectDamage(event);
        this.onAcidDamage(event);
    }

    private void onDirectDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1510 dragon;
        block5: {
            block4: {
                class_1297 class_12972 = event.getSource().method_5526();
                if (!(class_12972 instanceof class_1510)) break block4;
                dragon = (class_1510)class_12972;
                if (!(event.getEntity() instanceof class_1510)) break block5;
            }
            return;
        }
        class_2487 compoundNBT = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedDirectDamage * (double)difficulty));
    }

    private void onAcidDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1510 dragon;
        block5: {
            block4: {
                class_1297 class_12972 = event.getSource().method_5526();
                if (!(class_12972 instanceof class_1510)) break block4;
                dragon = (class_1510)class_12972;
                if (event.getSource().method_5529() instanceof class_1295) break block5;
            }
            return;
        }
        class_2487 compoundNBT = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedAcidPoolDamage * (double)difficulty));
    }

    public boolean onPhaseEnd(class_1510 dragon) {
        boolean chargePlayer = this.shouldChargePlayer(dragon);
        boolean fireballPlayer = this.shouldFireballPlayer(dragon);
        if (chargePlayer && fireballPlayer) {
            if (dragon.method_6051().method_43057() < 0.5f) {
                this.chargePlayer(dragon);
            } else {
                this.fireballPlayer(dragon);
            }
        } else if (chargePlayer) {
            this.chargePlayer(dragon);
        } else if (fireballPlayer) {
            this.fireballPlayer(dragon);
        }
        return chargePlayer || fireballPlayer;
    }

    private boolean shouldChargePlayer(class_1510 dragon) {
        double rng;
        if (this.chargePlayerMaxChance == 0.0) {
            return false;
        }
        if (dragon.method_6829() == null) {
            return false;
        }
        class_2487 tags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        double chance = this.chargePlayerMaxChance * (double)(difficulty / (float)Modules.dragon.difficulty.maxDifficulty);
        class_2338 centerPodium = dragon.field_6002.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600);
        class_238 boundingBox = new class_238(centerPodium).method_1014(64.0);
        List players = dragon.field_6002.method_8390(class_1657.class, boundingBox, class_1301.field_6156);
        for (class_1657 player : players) {
            List endCrystals = player.field_6002.method_18467(class_1511.class, player.method_5829().method_1014(10.0));
            if (endCrystals.size() <= 0) continue;
            chance *= 2.0;
            break;
        }
        return (rng = dragon.method_6051().method_43058()) < chance;
    }

    private void chargePlayer(class_1510 dragon) {
        class_2338 centerPodium = dragon.field_6002.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600);
        class_238 bb = new class_238(centerPodium).method_1014(64.0);
        class_3222 player = (class_3222)this.getRandomPlayerNearCrystal(dragon.field_6002, bb);
        if (player == null) {
            return;
        }
        dragon.method_6831().method_6863(class_1527.field_7078);
        class_243 targetPos = player.method_19538();
        targetPos = targetPos.field_1351 < dragon.method_23318() ? targetPos.method_1031(0.0, -5.0, 0.0) : targetPos.method_1031(0.0, 6.0, 0.0);
        ((class_1513)dragon.method_6831().method_6865(class_1527.field_7078)).method_6840(targetPos);
    }

    private boolean shouldFireballPlayer(class_1510 dragon) {
        if (this.fireballMaxChance == 0.0) {
            return false;
        }
        if (dragon.method_6829() == null) {
            return false;
        }
        class_2487 tags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return false;
        }
        double chance = this.fireballMaxChance * (double)(difficulty / (float)Modules.dragon.difficulty.maxDifficulty);
        double rng = dragon.method_6051().method_43058();
        return rng < chance;
    }

    private void fireballPlayer(class_1510 dragon) {
        class_2338 centerPodium = dragon.field_6002.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600);
        class_238 bb = new class_238(centerPodium).method_1014(64.0);
        class_3222 player = (class_3222)this.getRandomPlayer(dragon.field_6002, bb);
        if (player == null) {
            return;
        }
        dragon.method_6831().method_6863(class_1527.field_7076);
        ((class_1525)dragon.method_6831().method_6865(class_1527.field_7076)).method_6862((class_1309)player);
    }

    public boolean onFireballImpact(class_1670 fireball, @Nullable class_1297 shooter, class_239 result) {
        if (!this.isEnabled()) {
            return false;
        }
        this.onImpactExplosion(fireball, shooter, result);
        return this.onImpact3DCloud(fireball, result);
    }

    private void onImpactExplosion(class_1670 fireball, @Nullable class_1297 shooter, class_239 result) {
        if (!this.fireballExplosionDamages) {
            return;
        }
        float difficulty = 0.0f;
        if (shooter != null) {
            class_2487 compoundNBT = ((IEntityExtraData)shooter).getPersistentData();
            difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        }
        float damage = 6.0f * (1.0f + (float)(this.increasedAcidPoolDamage * (double)difficulty));
        class_238 axisAlignedBB = new class_238(result.method_17784(), result.method_17784()).method_1014(4.0);
        List livingEntities = fireball.field_6002.method_18467(class_1309.class, axisAlignedBB);
        for (class_1309 livingEntity : livingEntities) {
            if (!(livingEntity.method_5707(fireball.method_19538()) < 20.25)) continue;
            livingEntity.method_5643(new class_1284("progressivebosses:dragon_fireball", (class_1297)fireball, shooter).method_5508().method_5517().method_5515(), damage);
        }
    }

    private boolean onImpact3DCloud(class_1670 fireball, class_239 result) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.fireball3DEffectCloud) {
            return false;
        }
        class_239.class_240 raytraceresult$type = result.method_17783();
        if (raytraceresult$type == class_239.class_240.field_1331) {
            fireball.method_7454((class_3966)result);
        } else if (raytraceresult$type == class_239.class_240.field_1332) {
            fireball.method_24920((class_3965)result);
        }
        class_1297 entity = fireball.method_24921();
        if (!(result.method_17783() == class_239.class_240.field_1331 && ((class_3966)result).method_17782().method_5779(entity) || fireball.field_6002.field_9236)) {
            List list = fireball.field_6002.method_18467(class_1309.class, fireball.method_5829().method_1009(4.0, 2.0, 4.0));
            AreaEffectCloud3DEntity areaeffectcloudentity = new AreaEffectCloud3DEntity(fireball.field_6002, fireball.method_23317(), fireball.method_23318(), fireball.method_23321());
            if (entity instanceof class_1309) {
                areaeffectcloudentity.method_5607((class_1309)entity);
            }
            areaeffectcloudentity.method_5608((class_2394)class_2398.field_11216);
            areaeffectcloudentity.method_5603(3.0f);
            areaeffectcloudentity.method_5604(300);
            areaeffectcloudentity.method_5595(10);
            areaeffectcloudentity.method_5596((7.0f - areaeffectcloudentity.method_5599()) / (float)areaeffectcloudentity.method_5605());
            areaeffectcloudentity.method_5610(new class_1293(class_1294.field_5921, 1, 1));
            if (!list.isEmpty()) {
                for (class_1309 livingentity : list) {
                    double d0 = fireball.method_5858((class_1297)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloudentity.method_23327(livingentity.method_23317(), livingentity.method_23318(), livingentity.method_23321());
                    break;
                }
            }
            fireball.field_6002.method_20290(2006, fireball.method_24515(), fireball.method_5701() ? -1 : 1);
            fireball.field_6002.method_8649((class_1297)areaeffectcloudentity);
            fireball.method_31472();
        }
        return true;
    }

    public void fireFireball(class_1510 dragon, class_1309 attackTarget) {
        class_243 vector3d2 = dragon.method_5828(1.0f);
        double x = dragon.field_7017.method_23317() - vector3d2.field_1352;
        double y = dragon.field_7017.method_23323(0.5) + 0.5;
        double z = dragon.field_7017.method_23321() - vector3d2.field_1350;
        double xPower = attackTarget.method_23317() - x;
        double yPower = attackTarget.method_23323(0.5) - y;
        double zPower = attackTarget.method_23321() - z;
        if (!dragon.method_5701()) {
            dragon.field_6002.method_8444(null, 1017, dragon.method_24515(), 0);
        }
        class_1670 dragonfireballentity = new class_1670(dragon.field_6002, (class_1309)dragon, xPower, yPower, zPower);
        dragonfireballentity.method_5808(x, y, z, 0.0f, 0.0f);
        dragon.field_6002.method_8649((class_1297)dragonfireballentity);
        class_2487 compoundNBT = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        float fireballs = RandomHelper.getFloat(dragon.method_6051(), 0.0f, (float)(this.maxBonusFireball * (double)difficulty));
        fireballs = Utils.getAmountWithDecimalChance(dragon.method_6051(), fireballs);
        if (fireballs == 0.0f) {
            return;
        }
        int i = 0;
        while ((float)i < fireballs) {
            x = dragon.field_7017.method_23317() - vector3d2.field_1352;
            y = dragon.field_7017.method_23323(0.5) + 0.5;
            z = dragon.field_7017.method_23321() - vector3d2.field_1350;
            xPower = attackTarget.method_23317() + RandomHelper.getDouble(dragon.method_6051(), -fireballs, fireballs) - x;
            yPower = attackTarget.method_23323(0.5) + RandomHelper.getDouble(dragon.method_6051(), -fireballs, fireballs) - y;
            zPower = attackTarget.method_23321() + RandomHelper.getDouble(dragon.method_6051(), -fireballs, fireballs) - z;
            if (!dragon.method_5701()) {
                dragon.field_6002.method_8444(null, 1017, dragon.method_24515(), 0);
            }
            dragonfireballentity = new class_1670(dragon.field_6002, (class_1309)dragon, xPower, yPower, zPower);
            dragonfireballentity.method_5808(x, y, z, 0.0f, 0.0f);
            dragon.field_6002.method_8649((class_1297)dragonfireballentity);
            ++i;
        }
    }

    @Nullable
    public class_1657 getRandomPlayer(class_1937 world, class_238 boundingBox) {
        List players = world.method_8390(class_1657.class, boundingBox, class_1301.field_6156);
        if (players.isEmpty()) {
            return null;
        }
        int r = RandomHelper.getInt(world.field_9229, 0, players.size());
        return (class_1657)players.get(r);
    }

    @Nullable
    public class_1657 getRandomPlayerNearCrystal(class_1937 world, class_238 boundingBox) {
        List players = world.method_18467(class_1657.class, boundingBox);
        if (players.isEmpty()) {
            return null;
        }
        ArrayList<class_1657> playersNearCrystals = new ArrayList<class_1657>();
        for (class_1657 player : players) {
            List endCrystals = player.field_6002.method_8390(class_1511.class, player.method_5829().method_1014(10.0), class_1301.field_6156);
            if (endCrystals.size() <= 0) continue;
            playersNearCrystals.add(player);
        }
        if (playersNearCrystals.isEmpty()) {
            int r = RandomHelper.getInt(world.field_9229, 0, players.size());
            return (class_1657)players.get(r);
        }
        int r = RandomHelper.getInt(world.field_9229, 0, playersNearCrystals.size());
        return (class_1657)playersNearCrystals.get(r);
    }
}

