/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import java.util.Arrays;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1521;
import net.minecraft.class_1527;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

@ConfigEntries(includeAll=true)
@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Melee Damage reduction while at the center", comment="Melee Damage reduction per difficulty while the Ender Dragon is at the center.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double damageRedutionWhenSitting = 0.08;
    @ConfigEntry(nameKey="Explosion Damage reduction", comment="Damage reduction when hit by explosions (firework rockets excluded).")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double explosionDamageReduction = 0.667;
    @ConfigEntries.Exclude
    private static final List<class_1527<? extends class_1521>> sittingPhases = Arrays.asList(class_1527.field_7081, class_1527.field_7073, class_1527.field_7072, class_1527.field_7077);

    public ResistancesFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        LivingEntityEvents.HURT.register(event -> this.onDragonDamage(event));
    }

    public void onDragonDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        this.meleeDamageReduction(event, dragon);
        this.explosionDamageReduction(event, dragon);
    }

    private void meleeDamageReduction(LivingEntityEvents.OnLivingHurtEvent event, class_1510 dragon) {
        if (this.damageRedutionWhenSitting == 0.0) {
            return;
        }
        class_2487 compoundNBT = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        if (sittingPhases.contains(dragon.method_6831().method_6864().method_6849()) && event.getSource().method_5526() instanceof class_1657) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * (this.damageRedutionWhenSitting * (double)difficulty)));
        }
    }

    private void explosionDamageReduction(LivingEntityEvents.OnLivingHurtEvent event, class_1510 dragon) {
        if (this.explosionDamageReduction == 0.0) {
            return;
        }
        if (event.getSource().method_5535() && !event.getSource().method_5525().equals("fireworks")) {
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * this.explosionDamageReduction));
        }
    }
}

