/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.progressivebosses.module.elderguardian.ai.ElderMinionNearestAttackableTargetGoal;
import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1400;
import net.minecraft.class_1550;
import net.minecraft.class_1577;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_4135;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

@ConfigEntries(includeAll=true)
@Label(name="Minions", description="Elder Guardians will spawn Elder Minions.")
public class MinionFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Base Cooldown", comment="Elder Guardians will spawn Elder Minions every this tick value (20 ticks = 1 sec).")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int baseCooldown = 200;
    @ConfigEntry(nameKey="Cooldown Reduction per Missing Elder", comment="The base cooldown is reduced by this value for each missing Elder Guardian.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int cooldownReductionPerMissingGuardian = 60;

    public MinionFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onElderGuardianSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.update(new DummyEvent(entity.field_6002, (class_1297)entity)));
    }

    public void onElderGuardianSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getEntity();
        class_2487 witherTags = ((IEntityExtraData)elderGuardian).getPersistentData();
        witherTags.method_10569("progressivebosses:elder_minion_cooldown", this.baseCooldown);
    }

    public void update(DummyEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        class_1937 world = event.getEntity().field_6002;
        class_1550 elderGuardian = (class_1550)event.getEntity();
        class_2487 elderGuardianTags = ((IEntityExtraData)elderGuardian).getPersistentData();
        if (elderGuardian.method_6032() <= 0.0f) {
            return;
        }
        int cooldown = elderGuardianTags.method_10550("progressivebosses:elder_minion_cooldown");
        if (cooldown > 0) {
            elderGuardianTags.method_10569("progressivebosses:elder_minion_cooldown", cooldown - 1);
            return;
        }
        elderGuardianTags.method_10569("progressivebosses:elder_minion_cooldown", this.baseCooldown - this.cooldownReductionPerMissingGuardian * BaseFeature.getDeadElderGuardians(elderGuardian));
        int radius = 24;
        class_2338 pos1 = elderGuardian.method_24515().method_10069(-radius, -radius, -radius);
        class_2338 pos2 = elderGuardian.method_24515().method_10069(radius, radius, radius);
        class_238 bb = new class_238(pos1, pos2);
        List players = world.method_18467(class_3222.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.method_8390(class_1577.class, elderGuardian.method_5829().method_1014(12.0), entity -> ((IEntityExtraData)entity).getPersistentData().method_10545("progressivebosses:elder_minion"));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= 5) {
            return;
        }
        this.summonMinion(world, new class_243(elderGuardian.method_23317(), elderGuardian.method_23318(), elderGuardian.method_23321()));
    }

    public class_1577 summonMinion(class_1937 world, class_243 pos) {
        class_1577 elderMinion = new class_1577(class_1299.field_6118, world);
        class_2487 minionTags = ((IEntityExtraData)elderMinion).getPersistentData();
        minionTags.method_10556("mobspropertiesrandomness:processed", true);
        minionTags.method_10556("progressivebosses:elder_minion", true);
        elderMinion.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        elderMinion.method_5665((class_2561)class_5250.method_43477((class_7417)new class_2588("progressivebosses:elder_minion")));
        elderMinion.field_6198 = class_39.field_844;
        MCUtils.applyModifier((class_1309)elderMinion, class_5134.field_23719, Strings.AttributeModifiers.SWIM_SPEED_BONUS_UUID, "progressivebosses:swim_speed_bonus", 2.0, class_1322.class_1323.field_6330);
        ArrayList<class_1352> goalsToRemove = new ArrayList<class_1352>();
        for (class_4135 prioritizedGoal : elderMinion.field_6185.field_6461) {
            if (!(prioritizedGoal.method_19058() instanceof class_1400)) continue;
            goalsToRemove.add(prioritizedGoal.method_19058());
        }
        goalsToRemove.forEach(arg_0 -> ((class_1355)elderMinion.field_6201).method_6280(arg_0));
        elderMinion.field_6185.method_6277(1, new ElderMinionNearestAttackableTargetGoal<class_1657>((class_1308)elderMinion, class_1657.class, true));
        world.method_8649((class_1297)elderMinion);
        return elderMinion;
    }
}

