/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1550;

@ConfigEntries(includeAll=true)
@Label(name="Resistances", description="Handles the Damage Resistances")
public class ResistancesFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Damage Reduction per Elder Guardian Defeated", comment="Percentage Damage Reduction for each Elder Guardian Defeated.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double resistancePerElderGuardianDefeated = 0.3;

    public ResistancesFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        LivingEntityEvents.HURT.register(event -> this.onElderGuardianDamage(event));
    }

    public void onElderGuardianDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        if (this.resistancePerElderGuardianDefeated == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getEntity();
        float damageReduction = (float)((double)BaseFeature.getDeadElderGuardians(elderGuardian) * this.resistancePerElderGuardianDefeated);
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

