/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.module.dragon.entity.Larva;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.RandomHelper;
import insane96mcp.progressivebosses.utils.Strings;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_3033;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Larva", description="Mini things that are just annoying.")
public class LarvaFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Larva at Difficulty", comment="At which difficulty the Ender Dragon starts spawning Larvae")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int larvaAtDifficulty = 1;
    @ConfigEntry(nameKey="Bonus Larva Every Difficulty", comment="As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int bonusLarvaEveryDifficulty = 1;
    @ConfigEntry(nameKey="Max Larvae Spawned", comment="Maximum Larva spawned by the Ender Dragon")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int maxSpawned = 7;
    @ConfigEntry(nameKey="Minimum Cooldown", comment="Minimum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int minCooldown = 800;
    @ConfigEntry(nameKey="Maximum Cooldown", comment="Maximum ticks (20 ticks = 1 seconds) after Minions can spawn.")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int maxCooldown = 1400;
    @ConfigEntry(nameKey="Reduced Dragon Damage", comment="If true, Larvae will take only 10% damage from the Ender Dragon.")
    public boolean reducedDragonDamage = true;

    public LarvaFeature(LabelConfigGroup config) {
        config.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onDragonSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.update(new DummyEvent(entity.field_6002, (class_1297)entity)));
    }

    public void onDragonSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt(dragon.method_6051(), this.minCooldown, this.maxCooldown) * 0.5);
        dragonTags.method_10569("progressivebosses:dragon_larva_cooldown", cooldown);
    }

    public void update(DummyEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 dragon = (class_1510)class_12972;
        class_1937 world = event.getEntity().field_6002;
        class_2487 dragonTags = ((IEntityExtraData)dragon).getPersistentData();
        float difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        if (difficulty < (float)this.larvaAtDifficulty) {
            return;
        }
        if (dragon.method_6032() <= 0.0f) {
            return;
        }
        int cooldown = dragonTags.method_10550("progressivebosses:dragon_larva_cooldown");
        if (cooldown > 0) {
            dragonTags.method_10569("progressivebosses:dragon_larva_cooldown", cooldown - 1);
            return;
        }
        class_2338 centerPodium = dragon.field_6002.method_8598(class_2902.class_2903.field_13203, class_3033.field_13600);
        class_238 bb = new class_238(centerPodium).method_1014(64.0);
        List players = world.method_18467(class_3222.class, bb);
        if (players.isEmpty()) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt(world.field_9229, minCooldown, maxCooldown);
        dragonTags.method_10569("progressivebosses:dragon_larva_cooldown", cooldown - 1);
        int larvaSpawnedCount = 0;
        int i = this.larvaAtDifficulty;
        while ((float)i <= difficulty) {
            float angle = world.field_9229.method_43057() * (float)Math.PI * 2.0f;
            float x = (float)Math.floor(Math.cos(angle) * (double)3.33f);
            float z = (float)Math.floor(Math.sin(angle) * (double)3.33f);
            int y = world.method_8598(class_2902.class_2903.field_13197, new class_2338((double)x, 255.0, (double)z)).method_10264();
            this.summonLarva(world, new class_243((double)x + 0.5, (double)y, (double)z + 0.5), difficulty);
            if (++larvaSpawnedCount >= this.maxSpawned) break;
            i += this.bonusLarvaEveryDifficulty;
        }
    }

    public Larva summonLarva(class_1937 world, class_243 pos, float difficulty) {
        Larva larva = new Larva(ProgressiveBosses.LARVA, world);
        class_2487 minionTags = ((IEntityExtraData)((Object)larva)).getPersistentData();
        minionTags.method_10556("mobspropertiesrandomness:processed", true);
        larva.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        larva.method_5971();
        MCUtils.applyModifier((class_1309)larva, class_5134.field_23721, Strings.AttributeModifiers.ATTACK_DAMAGE_BONUS_UUID, "progressivebosses:attack_damage_bonus", 0.35 * (double)difficulty, class_1322.class_1323.field_6328);
        world.method_8649((class_1297)larva);
        return larva;
    }
}

