/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import com.google.common.util.concurrent.AtomicDouble;
import dev.onyxstudios.cca.internal.entity.CardinalEntityInternals;
import insane96mcp.progressivebosses.AComponents;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.Arrays;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1528;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;

@ConfigEntries(includeAll=true)
@Label(name="Difficulty Settings", description="How difficulty is handled for the Wither.")
public class DifficultyFeature
implements LabelConfigGroup {
    @ConfigEntries.Exclude
    private static final List<String> defaultEntityBlacklist = Arrays.asList("botania:pink_wither");
    @ConfigEntry(nameKey="Spawn Radius Player Check", comment="How much blocks from wither will be scanned for players to check for difficult")
    @ConfigEntry.BoundedInteger(min=16, max=0x7FFFFFFF)
    public int spawnRadiusPlayerCheck = 128;
    @ConfigEntry(nameKey="Sum Spawned Wither Difficulty", comment="If false and there's more than 1 player around the Wither, difficulty will be the average of all the players' difficulty instead of summing them.")
    public boolean sumSpawnedWitherDifficulty = false;
    @ConfigEntry(nameKey="Bonus Difficulty per Player", comment="Percentage bonus difficulty added to the Wither when more than one player is present. Each player past the first one will add this percentage to the difficulty.")
    @ConfigEntry.BoundedDouble(min=0.0, max=24.0)
    public double bonusDifficultyPerPlayer = 0.25;
    @ConfigEntry(nameKey="Max Difficulty", comment="The Maximum difficulty (times spawned) reachable by Wither.")
    @ConfigEntry.BoundedInteger(min=1, max=0x7FFFFFFF)
    public int maxDifficulty = 8;
    @ConfigEntry(nameKey="Starting Difficulty", comment="How much difficulty will players start with when joining a world? Note that this will apply when the first Wither is spawned so if the player has already spawned one this will not apply.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int startingDifficulty = 0;
    @ConfigEntry(nameKey="Show First Summoned Wither Message", comment="Set to false to disable the first Wither summoned message.")
    public boolean showFirstSummonedWitherMessage = true;
    @ConfigEntry(nameKey="Entity Blacklist", comment="Entities that extend the vanilla Wither but shouldn't be taken into account by the mod (e.g. Botania's Pink Wither).")
    public List<String> entityBlacklist = defaultEntityBlacklist;

    public DifficultyFeature(LabelConfigGroup config) {
        config.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.setPlayerData(new DummyEvent((class_1937)world, entity)));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        if (this.entityBlacklist.contains(class_7923.field_41177.method_10221((Object)event.getEntity().method_5864()).toString())) {
            return;
        }
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        if (witherTags.method_10545("progressivebosses:difficulty")) {
            return;
        }
        class_2338 pos1 = wither.method_24515().method_10069(-this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck);
        class_2338 pos2 = wither.method_24515().method_10069(this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck);
        class_238 bb = new class_238(pos1, pos2);
        List players = event.getWorld().method_8390(class_3222.class, bb, player -> player.method_5805());
        if (players.size() == 0) {
            return;
        }
        AtomicDouble witherDifficulty = new AtomicDouble(0.0);
        for (class_3222 player2 : players) {
            AComponents.DF.maybeGet((Object)player2).ifPresent(difficulty -> {
                witherDifficulty.addAndGet((double)difficulty.getSpawnedWithers());
                if (difficulty.getSpawnedWithers() >= this.maxDifficulty) {
                    return;
                }
                if (difficulty.getSpawnedWithers() <= this.startingDifficulty && this.showFirstSummonedWitherMessage) {
                    player2.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2588("wither.first_summon")), false);
                }
                difficulty.addSpawnedWithers(1);
                System.out.println("[Progressive Bosses] Player " + player2.method_5477().getString() + " spawned a Wither. Difficulty: " + difficulty.getSpawnedWithers());
            });
        }
        if (!this.sumSpawnedWitherDifficulty) {
            witherDifficulty.set(witherDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            witherDifficulty.set(witherDifficulty.get() * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        witherTags.method_10548("progressivebosses:difficulty", (float)witherDifficulty.get());
    }

    public void setPlayerData(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (!(event.getEntity() instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)event.getEntity();
        if (!AComponents.DF.maybeGet((Object)player).isPresent()) {
            CardinalEntityInternals.createEntityComponentContainer((class_1297)player);
        }
        AComponents.DF.maybeGet((Object)player).ifPresent(difficulty -> {
            if (difficulty.getSpawnedWithers() < this.startingDifficulty) {
                difficulty.setSpawnedWithers(this.startingDifficulty);
                LogHelper.info("[Progressive Bosses] %s spawned withers counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", player.method_5477().getString());
            }
            System.out.println("[Progressive Bosses] Player " + player.method_5477().getString() + " spawned a Wither. Difficulty: " + difficulty.getSpawnedWithers());
        });
    }
}

