/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.module.wither.entity.WitherMinion;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.RandomHelper;
import insane96mcp.progressivebosses.utils.Strings;
import java.util.List;
import java.util.UUID;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1528;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Minions", description="Wither will spawn deadly Minions")
public class MinionFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Minion at Difficulty", comment="At which difficulty the Wither starts spawning Minions")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int minionAtDifficulty = 1;
    @ConfigEntry(nameKey="Bonus Minion Every Difficulty", comment="As the Wither starts spawning Minions, every how much difficulty the Wither will spawn one more Minion")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int bonusMinionEveryDifficulty = 1;
    @ConfigEntry(nameKey="Max Minions Spawned", comment="Maximum Minions spawned by the Wither")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int maxSpawned = 6;
    @ConfigEntry(nameKey="Max Minions Around", comment="Maximum amount of Minions that can be around the Wither in a 16 block radius. After this number is reached the Wither will stop spawning minions. Set to 0 to disable this check")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int maxAround = 18;
    @ConfigEntry(nameKey="Minimum Cooldown", comment="Minimum ticks (20 ticks = 1 seconds) after Minions can spwan.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int minCooldown = 400;
    @ConfigEntry(nameKey="Maximum Cooldown", comment="Maximum ticks (20 ticks = 1 seconds) after Minions can spwan.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int maxCooldown = 700;
    @ConfigEntry(nameKey="Cooldown Multiplier Below Half Health", comment="Min and Max cooldowns are multiplied by this value when the Wither drops below half health. Set to 1 to not change the cooldown when the wither's health drops below half.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double cooldownMultiplierBelowHalfHealth = 0.6;
    @ConfigEntry(nameKey="Bonus Movement Speed Per Difficulty", comment="Percentage bonus speed per difficulty. (0.01 means 1%)")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusSpeedPerDifficulty = 0.03;
    @ConfigEntry(nameKey="Magic Damage Multiplier", comment="Wither Minions will take magic damage multiplied by this value.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double magicDamageMultiplier = 3.0;
    @ConfigEntry(nameKey="Kill Minions on Wither Death", comment="Wither Minions will die when the Wither that spawned them dies.")
    public boolean killMinionOnWitherDeath = true;
    @ConfigEntry(nameKey="Has Sword", comment="Wither Minions will spawn with a Stone Sword")
    public boolean hasSword = true;
    @ConfigEntry(nameKey="Bow Chance Over Half Health", comment="Chance for the Wither Minion to spawn with a bow when Wither's above Half Health")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double preHalfHealthBowChance = 0.6;
    @ConfigEntry(nameKey="Bow Chance Below Half Health", comment="Chance for the Wither Minion to spawn with a bow when Wither's below Half Health")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double halfHealthBowChance = 0.08;
    @ConfigEntry(nameKey="Power / Sharpness Chance", comment="Chance (per difficulty) for the Wither Minion Sword / Bow to be enchanted with Sharpness / Power. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining chance dictates if one more level will be added.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double powerSharpnessChance = 0.6;
    @ConfigEntry(nameKey="Punch / Knockback Chance", comment="Chance (per difficulty) for the Wither Minion Sword / Bow to be enchanted with Knockback / Punch. Note that every 100% chance adds one guaranteed level of the enchantment, while the remaining chance dictates if one more level will be added.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double punchKnockbackChance = 0.3;

    public MinionFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onWitherSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.update(new DummyEvent(entity.field_6002, (class_1297)entity)));
        LivingEntityEvents.HURT.register(event -> this.onMinionDamage(event));
        LivingEntityEvents.DEATH.register(event -> this.onDeath(event));
    }

    public void onWitherSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        int cooldown = (int)((double)RandomHelper.getInt(wither.field_6002.field_9229, this.minCooldown, this.maxCooldown) * this.cooldownMultiplierBelowHalfHealth);
        witherTags.method_10569("progressivebosses:wither_minion_cooldown", cooldown);
    }

    public void update(DummyEvent event) {
        class_2338 pos2;
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        class_1937 world = event.getEntity().field_6002;
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = witherTags.method_10583("progressivebosses:difficulty");
        if (difficulty < (float)this.minionAtDifficulty) {
            return;
        }
        if (wither.method_6032() <= 0.0f) {
            return;
        }
        if (wither.method_6884() > 0) {
            return;
        }
        int cooldown = witherTags.method_10550("progressivebosses:wither_minion_cooldown");
        if (cooldown > 0) {
            witherTags.method_10569("progressivebosses:wither_minion_cooldown", cooldown - 1);
            return;
        }
        int radius = 32;
        class_2338 pos1 = wither.method_24515().method_10069(-radius, -radius, -radius);
        class_238 bb = new class_238(pos1, pos2 = wither.method_24515().method_10069(radius, radius, radius));
        List players = world.method_18467(class_3222.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minionsInAABB = world.method_18467(WitherMinion.class, wither.method_5829().method_1014(16.0));
        int minionsCountInAABB = minionsInAABB.size();
        if (minionsCountInAABB >= this.maxAround) {
            return;
        }
        int minCooldown = this.minCooldown;
        int maxCooldown = this.maxCooldown;
        cooldown = RandomHelper.getInt(world.field_9229, minCooldown, maxCooldown);
        if (wither.method_6872()) {
            cooldown = (int)((double)cooldown * this.cooldownMultiplierBelowHalfHealth);
        }
        witherTags.method_10569("progressivebosses:wither_minion_cooldown", cooldown - 1);
        int minionSpawnedCount = 0;
        int i = this.minionAtDifficulty;
        while ((float)i <= difficulty) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (int t = 0; t < 5; ++t) {
                x = (int)(wither.method_23317() + (double)RandomHelper.getInt(world.field_9229, -3, 3));
                y = (int)(wither.method_23318() + 3.0);
                z = (int)(wither.method_23321() + (double)RandomHelper.getInt(world.field_9229, -3, 3));
                if ((y = MinionFeature.getYSpawn(ProgressiveBosses.WITHER_MINION, new class_2338(x, y, z), world, 8)) != -1) break;
            }
            if (y > wither.field_6002.method_31607()) {
                WitherMinion witherMinion = this.summonMinion(world, new class_243((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), difficulty, wither.method_6872());
                class_2499 minionsList = witherTags.method_10554("progressivebosses:minions", 10);
                class_2487 uuid = new class_2487();
                uuid.method_25927("uuid", witherMinion.method_5667());
                minionsList.add((Object)uuid);
                witherTags.method_10566("progressivebosses:minions", (class_2520)minionsList);
                if (++minionSpawnedCount >= this.maxSpawned || ++minionsCountInAABB >= this.maxAround) break;
            }
            i += this.bonusMinionEveryDifficulty;
        }
    }

    public void onMinionDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        if (this.magicDamageMultiplier == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof WitherMinion)) {
            return;
        }
        if (event.getSource().method_5527()) {
            event.setAmount((float)((double)event.getAmount() * this.magicDamageMultiplier));
        }
    }

    public void onDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (event.getEntity().field_6002.field_9236) {
            return;
        }
        if (!this.killMinionOnWitherDeath) {
            return;
        }
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_13092;
        class_3218 world = (class_3218)wither.field_6002;
        class_2487 tags = ((IEntityExtraData)wither).getPersistentData();
        class_2499 minionsList = tags.method_10554("progressivebosses:minions", 10);
        for (int i = 0; i < minionsList.size(); ++i) {
            UUID uuid = minionsList.method_10602(i).method_25926("uuid");
            WitherMinion witherMinion = (WitherMinion)world.method_14190(uuid);
            if (witherMinion == null) continue;
            witherMinion.method_6092(new class_1293(class_1294.field_5915, 10000, 0, false, false));
        }
    }

    private void setEquipment(WitherMinion witherMinion, float difficulty, boolean isCharged) {
        witherMinion.method_5946(class_1304.field_6173, Float.MIN_VALUE);
        int powerSharpnessLevel = (int)(this.powerSharpnessChance * (double)difficulty);
        if (RandomHelper.getDouble(witherMinion.field_6002.method_8409(), 0.0, 1.0) < this.powerSharpnessChance * (double)difficulty - (double)powerSharpnessLevel) {
            ++powerSharpnessLevel;
        }
        int punchKnockbackLevel = (int)(this.punchKnockbackChance * (double)difficulty);
        if (RandomHelper.getDouble(witherMinion.field_6002.method_8409(), 0.0, 1.0) < this.punchKnockbackChance * (double)difficulty - (double)punchKnockbackLevel) {
            ++punchKnockbackLevel;
        }
        class_1799 sword = new class_1799((class_1935)class_1802.field_8528);
        if (powerSharpnessLevel > 0) {
            sword.method_7978(class_1893.field_9118, powerSharpnessLevel);
        }
        if (punchKnockbackLevel > 0) {
            sword.method_7978(class_1893.field_9121, punchKnockbackLevel);
        }
        if (this.hasSword) {
            witherMinion.method_5673(class_1304.field_6173, sword);
        }
        class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
        if (powerSharpnessLevel > 0) {
            bow.method_7978(class_1893.field_9103, powerSharpnessLevel);
        }
        if (punchKnockbackLevel > 0) {
            bow.method_7978(class_1893.field_9103, punchKnockbackLevel);
        }
        if (isCharged) {
            if (RandomHelper.getDouble(witherMinion.field_6002.method_8409(), 0.0, 1.0) < this.halfHealthBowChance) {
                witherMinion.method_5673(class_1304.field_6173, bow);
            }
        } else if (RandomHelper.getDouble(witherMinion.field_6002.method_8409(), 0.0, 1.0) < this.preHalfHealthBowChance) {
            witherMinion.method_5673(class_1304.field_6173, bow);
        }
    }

    private static int getYSpawn(class_1299<WitherMinion> entityType, class_2338 pos, class_1937 world, int minRelativeY) {
        int height = (int)Math.ceil(entityType.method_17686());
        int fittingYPos = -1;
        for (int y = pos.method_10264(); y > pos.method_10264() - minRelativeY; --y) {
            boolean viable = true;
            class_2338 p = new class_2338(pos.method_10263(), y, pos.method_10260());
            for (int i = 0; i < height; ++i) {
                if (!world.method_8320(p.method_10086(i)).method_26207().method_15801()) continue;
                viable = false;
                break;
            }
            if (!viable) continue;
            fittingYPos = y;
            if (!world.method_8320(p.method_10074()).method_26207().method_15801()) continue;
            return y;
        }
        return fittingYPos;
    }

    public WitherMinion summonMinion(class_1937 world, class_243 pos, float difficulty, boolean isCharged) {
        WitherMinion witherMinion = new WitherMinion(ProgressiveBosses.WITHER_MINION, world);
        class_2487 minionTags = ((IEntityExtraData)((Object)witherMinion)).getPersistentData();
        minionTags.method_10556("mobspropertiesrandomness:processed", true);
        witherMinion.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        this.setEquipment(witherMinion, difficulty, isCharged);
        witherMinion.method_5946(class_1304.field_6173, -0.04f);
        witherMinion.method_5971();
        double speedBonus = this.bonusSpeedPerDifficulty * (double)difficulty;
        MCUtils.applyModifier((class_1309)witherMinion, class_5134.field_23719, Strings.AttributeModifiers.MOVEMENT_SPEED_BONUS_UUID, "progressivebosses:movement_speed_bonus", speedBonus, class_1322.class_1323.field_6330);
        MCUtils.applyModifier((class_1309)witherMinion, class_5134.field_23717, Strings.AttributeModifiers.FOLLOW_RANGE_BONUS_UUID, "progressivebosses:follow_range_bonus", 16.0, class_1322.class_1323.field_6328);
        world.method_8649((class_1297)witherMinion);
        return witherMinion;
    }
}

