/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1528;
import net.minecraft.class_2487;

@ConfigEntries(includeAll=true)
@Label(name="Resistances & Vulnerabilities", description="Handles the Damage Resistances and Vulnerabilities")
public class ResistancesFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Melee Damage reduction per Difficulty above half health", comment="Percentage Melee Damage Reduction (per difficulty) while the Wither is above half health.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double meleeDamageReductionBeforeHalfHealth = 0.03;
    @ConfigEntry(nameKey="Max Melee Damage reduction per Difficulty before half health", comment="Cap for 'Melee Damage reduction per Difficulty above half health'")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double maxMeleeDamageReductionBeforeHalfHealth = 0.24;
    @ConfigEntry(nameKey="Melee Damage reduction per Difficulty below half health", comment="Percentage Melee Damage Reduction (per difficulty) as the Wither drops below half health.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double meleeDamageReductionOnHalfHealth = 0.06;
    @ConfigEntry(nameKey="Max Melee Damage reduction per Difficulty below half health", comment="Cap for 'Melee Damage Reduction per Difficulty below half health'")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double maxDamageReductionOnHalfHealth = 0.48;
    @ConfigEntry(nameKey="Magic Damage Bonus", comment="Bonus magic damage based off missing health. 150 means that every 150 missing health the damage will be amplified by 100%. E.g. The difficulty = 0 Wither (with 300 max health) is at half health (so it's missing 150hp), on magic damage he will receive 'magic_damage * (missing_health / magic_damage_bonus + 1)' = 'magic_damage * (150 / 150 + 1)' = 'magic_damage * 2'.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1024.0)
    public double magicDamageBonus = 250.0;

    public ResistancesFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        LivingEntityEvents.HURT.register(event -> this.onWitherDamage(event));
    }

    public void onWitherDamage(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        if (!(this.meleeDamageReductionOnHalfHealth != 0.0 && this.maxDamageReductionOnHalfHealth != 0.0 || this.meleeDamageReductionBeforeHalfHealth != 0.0 && this.maxMeleeDamageReductionBeforeHalfHealth != 0.0 || this.magicDamageBonus != 0.0)) {
            return;
        }
        if (event.getSource().method_5527() && this.magicDamageBonus > 0.0) {
            double missingHealth = wither.method_6063() - wither.method_6032();
            event.setAmount(event.getAmount() * (float)(missingHealth / this.magicDamageBonus + 1.0));
        }
        if (event.getSource().method_5529() != event.getSource().method_5526()) {
            return;
        }
        class_2487 tags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        float damageReduction = !wither.method_6872() ? (float)Math.min(this.maxMeleeDamageReductionBeforeHalfHealth, (double)difficulty * this.meleeDamageReductionBeforeHalfHealth) : (float)Math.min(this.maxDamageReductionOnHalfHealth, (double)difficulty * this.meleeDamageReductionOnHalfHealth);
        if ((double)damageReduction == 0.0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

