/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.Strings;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1510;
import net.minecraft.class_1527;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Health", description="Bonus Health and Bonus regeneration.")
public class HealthFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Health Bonus per Difficulty", comment="Increase Ender Dragon's Health by this value per difficulty")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusPerDifficulty = 25.0;
    @ConfigEntry(nameKey="Maximum Bonus Regeneration", comment="Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the crystal regeneration of the Ender Dragon.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double maxBonusRegen = 1.0;
    @ConfigEntry(nameKey="Bonus Regeneration per Difficulty", comment="How much health will the Ender Dragon regen per difficulty. This is added to the noaml Crystal regeneration.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusRegenPerDifficulty = 0.125;
    @ConfigEntry(nameKey="Bonus Crystal Regeneration", comment="How much health (when missing 100% health) will the Ender Dragon regen per difficulty each second whenever she's attached to a Crystal. So if she's missing 30% health, this will be 30% effective. This is added to the normal Crystal regen.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusCrystalRegen = 0.0;

    public HealthFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.method_37908(), (class_1297)entity)));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 enderDragon = (class_1510)class_12972;
        if (enderDragon.method_5996(class_5134.field_23716).method_6199(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        class_2487 dragonTags = ((IEntityExtraData)enderDragon).getPersistentData();
        double difficulty = dragonTags.method_10583("progressivebosses:difficulty");
        MCUtils.applyModifier((class_1309)enderDragon, class_5134.field_23716, Strings.AttributeModifiers.BONUS_HEALTH_UUID, "progressivebosses:bonus_health", difficulty * this.bonusPerDifficulty, class_1322.class_1323.field_6328);
    }

    public void onUpdate(DummyEvent event) {
        float crystalBonusHeal;
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1510)) {
            return;
        }
        class_1510 enderDragon = (class_1510)class_12972;
        if (!enderDragon.method_5805() || enderDragon.method_6831().method_6864().method_6849() == class_1527.field_7068) {
            return;
        }
        class_2487 tags = ((IEntityExtraData)enderDragon).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float flatBonusHeal = this.getFlatBonusHeal(difficulty);
        float heal = flatBonusHeal + (crystalBonusHeal = this.getCrystalBonusHeal(enderDragon, difficulty));
        if (heal == 0.0f) {
            return;
        }
        enderDragon.method_6025(heal /= 20.0f);
    }

    private float getFlatBonusHeal(float difficulty) {
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return 0.0f;
        }
        return (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
    }

    private float getCrystalBonusHeal(class_1510 enderDragon, float difficulty) {
        if (this.bonusCrystalRegen == 0.0) {
            return 0.0f;
        }
        if (enderDragon.field_7024 == null || !enderDragon.field_7024.method_5805()) {
            return 0.0f;
        }
        double currHealthPerc = 1.0f - enderDragon.method_6032() / enderDragon.method_6063();
        return (float)(this.bonusCrystalRegen * (double)difficulty * currHealthPerc);
    }
}

