/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.progressivebosses.module.elderguardian.feature.BaseFeature;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1550;

@ConfigEntries(includeAll=true)
@Label(name="Attack", description="More damage and attack speed based off Elder Guardians Defeated")
public class AttackFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Bonus Damage per Elder Guardian Defeated", comment="Percentage Bonus damage per defeated Elder Guardian.")
    @ConfigEntry.BoundedDouble(min=0.0, max=128.0)
    public double bonusDamage = 0.0;
    @ConfigEntry(nameKey="Attack Duration Reduction per Elder Guardian Defeated", comment="How many ticks faster will Elder Guardian attack (multiplied by defeated Elder Guardians). Vanilla Attack Duration is 60 ticks (3 secs)")
    @ConfigEntry.BoundedInteger(min=0, max=60)
    public int attackDurationReduction = 25;
    @ConfigEntries.Exclude
    private static final int BASE_ATTACK_DURATION = 60;

    public AttackFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        LivingEntityEvents.HURT.register(event -> this.onDamageDealt(event));
    }

    public void onDamageDealt(LivingEntityEvents.OnLivingHurtEvent event) {
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        if (this.bonusDamage == 0.0) {
            return;
        }
        if (!(event.getSource().method_5526() instanceof class_1550)) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getSource().method_5526();
        float bonusDamage = (float)(this.bonusDamage * (double)BaseFeature.getDeadElderGuardians(elderGuardian));
        event.setAmount(event.getAmount() * (1.0f + bonusDamage));
    }

    public int getAttackDuration(class_1550 elderGuardian) {
        if (this.attackDurationReduction == 0) {
            return 60;
        }
        int elderGuardiansNearby = elderGuardian.method_37908().method_8333((class_1297)elderGuardian, elderGuardian.method_5829().method_1014(48.0), entity -> entity instanceof class_1550).size();
        if (elderGuardiansNearby == 2) {
            return 60;
        }
        return 60 - (2 - elderGuardiansNearby) * this.attackDurationReduction;
    }
}

