/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.progressivebosses.utils.ExplosionEvents;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.PlayerEntityEvents;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1550;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

@ConfigEntries(includeAll=true)
@Label(name="Base", description="Base feature for the Elder Guardian harder fights. Disabling this feature will disable the added sound when an Elder Guardian is killed.")
public class BaseFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Adventure mode", comment="If true, the player will not be able to break blocks when an Elder Guardian is nearby.")
    public boolean adventure = true;

    public BaseFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        PlayerEntityEvents.TICK.register(player -> this.onPlayerTick(player));
        LivingEntityEvents.DEATH.register(event -> this.onPlayerDeath(event));
        ExplosionEvents.EXPLODE.register(event -> this.onExplosionDetonate(event));
        LivingEntityEvents.DEATH.register(event -> this.onElderGuardianDeath(event));
    }

    public void onPlayerTick(class_1657 player) {
        if (player.method_37908().field_9236) {
            return;
        }
        if (!this.adventure) {
            return;
        }
        if (player.field_6012 % 20 != 0) {
            return;
        }
        if (!player.method_5805()) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3218 world = (class_3218)serverPlayer.method_37908();
        class_2487 nbt = ((IEntityExtraData)serverPlayer).getPersistentData();
        boolean previouslyNearElderGuardian = nbt.method_10577("progressivebosses:previously_near_elder_guardian");
        boolean adventureMessage = nbt.method_10577("progressivebosses:adventure_message");
        boolean nearElderGuardian = !world.method_8390(class_1550.class, serverPlayer.method_5829().method_1014(32.0), entity -> true).isEmpty();
        nbt.method_10556("progressivebosses:previously_near_elder_guardian", nearElderGuardian);
        if (serverPlayer.field_13974.method_14257() == class_1934.field_9215 && nearElderGuardian) {
            serverPlayer.field_13974.method_30118(class_1934.field_9216);
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9216.method_8379()));
            if (!adventureMessage) {
                serverPlayer.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2588("elder_guardian.approach", "translate error at APPROACHING_ELDER_GUARDIAN", new Object[0])), false);
                nbt.method_10556("progressivebosses:adventure_message", true);
            }
        } else if (serverPlayer.field_13974.method_14257() == class_1934.field_9216 && !nearElderGuardian && previouslyNearElderGuardian) {
            serverPlayer.field_13974.method_30118(class_1934.field_9215);
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
        }
    }

    public void onPlayerDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (!this.adventure) {
            return;
        }
        if (!(event.getEntity() instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)event.getEntity();
        class_2487 nbt = ((IEntityExtraData)serverPlayer).getPersistentData();
        boolean previouslyNearElderGuardian = nbt.method_10577("progressivebosses:previously_near_elder_guardian");
        if (previouslyNearElderGuardian && serverPlayer.field_13974.method_14257() == class_1934.field_9216) {
            serverPlayer.field_13974.method_30118(class_1934.field_9215);
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9215.method_8379()));
        }
    }

    public void onExplosionDetonate(ExplosionEvents.OnExplosionEvent event) {
        boolean nearElderGuardian;
        if (!this.adventure) {
            return;
        }
        if (event.getExplosion().method_8347() == null) {
            return;
        }
        if (event.getExplosion().field_9184 == class_1927.class_4179.field_40878) {
            return;
        }
        boolean bl = nearElderGuardian = !event.getWorld().method_8390(class_1550.class, event.getExplosion().method_8347().method_5829().method_1014(32.0), e -> true).isEmpty();
        if (nearElderGuardian) {
            event.setCancelled();
            event.getWorld().method_8537((class_1297)event.getExplosion().method_8347(), event.getPosition().field_1352, event.getPosition().field_1351, event.getPosition().field_1350, event.getExplosion().field_9190, event.getExplosion().field_9186, class_1937.class_7867.field_40890);
        }
    }

    public void onElderGuardianDeath(LivingEntityEvents.OnLivingDeathEvent event) {
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getEntity();
        int elderGuardiansNearby = elderGuardian.method_37908().method_8333((class_1297)elderGuardian, elderGuardian.method_5829().method_1014(48.0), entity -> entity instanceof class_1550).size();
        if (elderGuardiansNearby == 0) {
            return;
        }
        elderGuardian.method_5783(class_3417.field_15203, 2.0f, 0.5f);
    }

    public static int getDeadElderGuardians(class_1550 elderGuardian) {
        int elderGuardiansNearby = elderGuardian.method_37908().method_8333((class_1297)elderGuardian, elderGuardian.method_5829().method_1014(48.0), entity -> entity instanceof class_1550).size();
        return 2 - elderGuardiansNearby;
    }
}

