/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.Strings;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1550;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Health", description="Bonus Health and Health regeneration.")
public class HealthFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Health Bonus", comment="Increase Elder Guardians' Health by this percentage (1 = +100% health)")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusHealth = 0.5;
    @ConfigEntry(nameKey="Absorption Health", comment="Adds absorption health to Elder Guradians (health that doesn't regen)")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double absorptionHealth = 40.0;
    @ConfigEntry(nameKey="Health Regen", comment="Health Regen per second")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double healthRegen = 0.5;

    public HealthFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.method_37908(), (class_1297)entity)));
    }

    public void onSpawn(DummyEvent event) {
        if (event.getWorld().field_9236) {
            return;
        }
        if (this.bonusHealth == 0.0 && this.absorptionHealth == 0.0) {
            return;
        }
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getEntity();
        class_2487 nbt = ((IEntityExtraData)elderGuardian).getPersistentData();
        if (nbt.method_10577("progressivebosses:difficulty")) {
            return;
        }
        nbt.method_10556("progressivebosses:difficulty", true);
        if (this.bonusHealth > 0.0) {
            if (elderGuardian.method_5996(class_5134.field_23716).method_6199(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
                return;
            }
            MCUtils.applyModifier((class_1309)elderGuardian, class_5134.field_23716, Strings.AttributeModifiers.BONUS_HEALTH_UUID, "progressivebosses:bonus_health", this.bonusHealth, class_1322.class_1323.field_6330);
        }
        if (this.absorptionHealth > 0.0) {
            elderGuardian.method_6073((float)this.absorptionHealth);
        }
    }

    public void onUpdate(DummyEvent event) {
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        if (!(event.getEntity() instanceof class_1550)) {
            return;
        }
        if (this.healthRegen == 0.0) {
            return;
        }
        class_1550 elderGuardian = (class_1550)event.getEntity();
        if (!elderGuardian.method_5805()) {
            return;
        }
        float heal = (float)this.healthRegen / 20.0f;
        elderGuardian.method_6025(heal);
    }
}

