/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.module.wither.ai.WitherChargeAttackGoal;
import insane96mcp.progressivebosses.module.wither.ai.WitherRangedAttackGoal;
import insane96mcp.progressivebosses.network.PacketManagerServer;
import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import java.util.ArrayList;
import java.util.UUID;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1381;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Attack", description="Makes the Wither smarter (will no longer try to stand on the player's head ...), attack faster and hit harder")
public class AttackFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Wither Attack", comment="Makes the Wither smarter (will no longer try to stand on the player's head ...), attack faster and hit harder")
    public boolean applyToVanillaWither = true;
    @ConfigEntry(nameKey="Max Charge Attack Chance", comment="Chance every time the Wither takes damage to start a charge attack. Less health = higher chance and more damage taken = more chance. This value is the chance at 0% health and when taking 10 damage.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double maxChargeAttackChance = 0.06;
    @ConfigEntry(nameKey="Increased Damage", comment="Percentage bonus damage dealt by the Wither per difficulty.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double increasedDamage = 0.12;
    @ConfigEntry(nameKey="Barrage Attack", comment="Chance (per difficulty) every time the Wither takes damage to start a barrage attack. Less health = higher chance and more damage taken = more chance. This value is the chance at 0% health and when taking 10 damage.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
    public double maxBarrageChancePerDiff = 0.011;
    @ConfigEntry(nameKey="Min Barrage Duration", comment="Min time (in ticks) for the duration of the barrage attack. Less health = longer barrage.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int minBarrageDuration = 20;
    @ConfigEntry(nameKey="Max Barrage Duration", comment="Max time (in ticks) for the duration of the barrage attack. Less health = longer barrage")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int maxBarrageDuration = 150;
    @ConfigEntry(nameKey="Skulls", comment="Wither Skull Changes")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double skullVelocityMultiplier = 2.75;
    @ConfigEntry(nameKey="Attack Speed", comment="Attack Speed Changes")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFF)
    public int attackInterval = 40;
    @ConfigEntry(nameKey="Increase Attack Speed when Near", comment="The middle head will attack faster (up to 40% of the attack speed) the nearer the target is to the Wither.")
    public boolean increaseAttackSpeedWhenNear = true;

    public AttackFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.method_37908(), (class_1297)entity)));
        LivingEntityEvents.HURT.register(event -> this.onDamaged(event));
        LivingEntityEvents.HURT.register(event -> this.onDamageDealt(event));
    }

    public void onSpawn(DummyEvent event) {
        this.witherSkullSpeed(event.getEntity());
        if (event.getWorld().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        class_2487 compoundNBT = ((IEntityExtraData)wither).getPersistentData();
        if (!(compoundNBT.method_10545("progressivebosses:difficulty") && compoundNBT.method_10583("progressivebosses:difficulty") != 0.0f || this.applyToVanillaWither)) {
            return;
        }
        this.setWitherAI(wither);
    }

    private void witherSkullSpeed(class_1297 entity) {
        if (!(entity instanceof class_1687)) {
            return;
        }
        class_1687 witherSkullEntity = (class_1687)entity;
        if (this.skullVelocityMultiplier == 0.0) {
            return;
        }
        if (Math.abs(witherSkullEntity.field_7601) > 10.0 || Math.abs(witherSkullEntity.field_7600) > 10.0 || Math.abs(witherSkullEntity.field_7599) > 10.0) {
            entity.method_5768();
            return;
        }
        witherSkullEntity.field_7601 *= this.skullVelocityMultiplier;
        witherSkullEntity.field_7600 *= this.skullVelocityMultiplier;
        witherSkullEntity.field_7599 *= this.skullVelocityMultiplier;
    }

    public void onUpdate(DummyEvent event) {
        if (!event.getEntity().method_5805()) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        this.tickCharge(wither);
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        this.chargeUnseen(wither);
    }

    private void tickCharge(class_1528 wither) {
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        byte chargeTick = ((IEntityExtraData)wither).getPersistentData().method_10571("progressivebosses:charge_attack");
        if (chargeTick > 0) {
            if (wither.field_6012 % 10 == 0) {
                float missingHealth = wither.method_6063() - wither.method_6032();
                wither.method_6033(wither.method_6032() + missingHealth * 0.005f);
            }
            ((IEntityExtraData)wither).getPersistentData().method_10567("progressivebosses:charge_attack", (byte)(chargeTick - 1));
        }
    }

    private void chargeUnseen(class_1528 wither) {
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        if (witherTags.method_10571("progressivebosses:charge_attack") <= 0 && wither.field_6012 % 20 == 0) {
            this.doCharge(wither, (float)witherTags.method_10550("progressivebosses:unseen_player_ticks") / 20.0f);
        }
    }

    public void onDamageDealt(LivingEntityEvents.OnLivingHurtEvent event) {
        class_1528 wither;
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        if (this.increasedDamage == 0.0) {
            return;
        }
        if (event.getSource().method_5529() instanceof class_1528) {
            wither = (class_1528)event.getSource().method_5529();
        } else if (event.getSource().method_5526() instanceof class_1528) {
            wither = (class_1528)event.getSource().method_5526();
        } else {
            return;
        }
        class_2487 compoundNBT = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = compoundNBT.method_10583("progressivebosses:difficulty");
        event.setAmount(event.getAmount() * (float)(1.0 + this.increasedDamage * (double)difficulty));
    }

    public void onDamaged(LivingEntityEvents.OnLivingHurtEvent event) {
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        if (!event.getEntity().method_5805()) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        this.doBarrage(wither, event.getAmount());
        this.doCharge(wither, event.getAmount());
    }

    private void doBarrage(class_1528 wither, float damageTaken) {
        if (this.maxBarrageChancePerDiff == 0.0) {
            return;
        }
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = witherTags.method_10583("progressivebosses:difficulty");
        double missingHealthPerc = 1.0 - (double)(wither.method_6032() / wither.method_6063());
        double chance = this.maxBarrageChancePerDiff * (double)difficulty * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.method_6051().method_43058();
        if (r < chance) {
            int duration = (int)((double)(this.maxBarrageDuration - this.minBarrageDuration) * missingHealthPerc + (double)this.minBarrageDuration);
            witherTags.method_10569("progressivebosses:barrage_attack", duration);
        }
    }

    private void doCharge(class_1528 wither, float damageTaken) {
        if (this.maxChargeAttackChance == 0.0) {
            return;
        }
        if (((IEntityExtraData)wither).getPersistentData().method_10571("progressivebosses:charge_attack") > 0) {
            return;
        }
        double missingHealthPerc = 1.0 - (double)(wither.method_6032() / wither.method_6063());
        double chance = this.maxChargeAttackChance * missingHealthPerc;
        chance *= (double)(damageTaken / 10.0f);
        double r = wither.method_6051().method_43058();
        if (r < chance) {
            AttackFeature.initCharging(wither);
        }
    }

    public void setWitherAI(class_1528 wither) {
        ArrayList<class_1352> toRemove = new ArrayList<class_1352>();
        wither.field_6201.field_6461.forEach(goal -> {
            if (goal.method_19058() instanceof class_1381) {
                toRemove.add(goal.method_19058());
            }
            if (goal.method_19058() instanceof class_1528.class_1529) {
                toRemove.add(goal.method_19058());
            }
        });
        toRemove.forEach(arg_0 -> ((class_1355)wither.field_6201).method_6280(arg_0));
        wither.field_6201.method_6277(1, (class_1352)new WitherChargeAttackGoal(wither));
        wither.field_6201.method_6277(2, (class_1352)new WitherRangedAttackGoal(wither, this.attackInterval, 24.0f, this.increaseAttackSpeedWhenNear));
        MCUtils.applyModifier((class_1309)wither, class_5134.field_23717, UUID.randomUUID(), "Wither Glasses", 48.0, class_1322.class_1323.field_6328);
    }

    public static void initCharging(class_1528 wither) {
        ((IEntityExtraData)wither).getPersistentData().method_10567("progressivebosses:charge_attack", (byte)90);
        for (class_1657 player : wither.method_37908().method_18456()) {
            PacketManagerServer.MessageWitherSync((class_3222)player, wither, (byte)90);
        }
    }

    public static void stopCharging(class_1528 wither) {
        ((IEntityExtraData)wither).getPersistentData().method_10567("progressivebosses:charge_attack", (byte)0);
        for (class_1657 player : wither.method_37908().method_18456()) {
            PacketManagerServer.MessageWitherSync((class_3222)player, wither, (byte)0);
        }
    }

    public static class Consts {
        public static final int CHARGE_ATTACK_TICK_START = 90;
        public static final int CHARGE_ATTACK_TICK_CHARGE = 30;
    }
}

