/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.progressivebosses.utils.DummyEvent;
import insane96mcp.progressivebosses.utils.IEntityExtraData;
import insane96mcp.progressivebosses.utils.Label;
import insane96mcp.progressivebosses.utils.LabelConfigGroup;
import insane96mcp.progressivebosses.utils.LivingEntityEvents;
import insane96mcp.progressivebosses.utils.MCUtils;
import insane96mcp.progressivebosses.utils.Strings;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1528;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

@ConfigEntries(includeAll=true)
@Label(name="Health", description="Bonus Health and Bonus regeneration. The feature even fixes the Wither health bar not updating on spawn.")
public class HealthFeature
implements LabelConfigGroup {
    @ConfigEntry(nameKey="Health Bonus per Difficulty", comment="Increase Wither's Health by this value per difficulty")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusPerDifficulty = 90.0;
    @ConfigEntry(nameKey="Maximum Bonus Regeneration", comment="Maximum bonus regeneration per second given by \"Bonus Regeneration per Difficulty\". Set to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second). Note that the health regen is disabled when Wither's health is between 49% and 50% to prevent making it impossible to approach when half health.")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double maxBonusRegen = 2.0;
    @ConfigEntry(nameKey="Bonus Regeneration per Difficulty", comment="How many half hearts will the Wither regen per difficulty. This is added to the natural regeneration of the Wither (1 Health per Second).")
    @ConfigEntry.BoundedDouble(min=0.0, max=1.7976931348623157E308)
    public double bonusRegenPerDifficulty = 0.3;

    public HealthFeature(LabelConfigGroup parent) {
        parent.addConfigContainer((ConfigContainer)this);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> this.onSpawn(new DummyEvent((class_1937)world, entity)));
        LivingEntityEvents.TICK.register(entity -> this.onUpdate(new DummyEvent(entity.method_37908(), (class_1297)entity)));
    }

    public void onSpawn(DummyEvent event) {
        boolean hasInvulTicks;
        if (event.getWorld().field_9236) {
            return;
        }
        if (this.bonusPerDifficulty == 0.0) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        if (wither.method_5996(class_5134.field_23716).method_6199(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        class_2487 witherTags = ((IEntityExtraData)wither).getPersistentData();
        double difficulty = witherTags.method_10583("progressivebosses:difficulty");
        MCUtils.applyModifier((class_1309)wither, class_5134.field_23716, Strings.AttributeModifiers.BONUS_HEALTH_UUID, "progressivebosses:bonus_health", difficulty * this.bonusPerDifficulty, class_1322.class_1323.field_6328);
        boolean bl = hasInvulTicks = wither.method_6884() > 0;
        if (hasInvulTicks) {
            wither.method_6033(Math.max(1.0f, wither.method_6063() - 200.0f));
        }
    }

    public void onUpdate(DummyEvent event) {
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        class_1297 class_12972 = event.getEntity();
        if (!(class_12972 instanceof class_1528)) {
            return;
        }
        class_1528 wither = (class_1528)class_12972;
        if (this.bonusRegenPerDifficulty == 0.0 || this.maxBonusRegen == 0.0) {
            return;
        }
        if (wither.method_6884() > 0 || !wither.method_5805()) {
            return;
        }
        if (wither.method_6032() / wither.method_6063() > 0.49f && wither.method_6032() / wither.method_6063() < 0.5f) {
            return;
        }
        class_2487 tags = ((IEntityExtraData)wither).getPersistentData();
        float difficulty = tags.method_10583("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float heal = (float)Math.min((double)difficulty * this.bonusRegenPerDifficulty, this.maxBonusRegen);
        wither.method_6025(heal /= 20.0f);
    }

    private void fixInvulBossBar(class_1528 wither) {
        if (wither.method_6884() == 0) {
            return;
        }
        wither.field_7093.method_5408(wither.method_6032() / wither.method_6063());
    }
}

