/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.utils;

import insane96mcp.progressivebosses.ProgressiveBosses;
import insane96mcp.progressivebosses.utils.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public class Drop {
    public class_2960 itemId;
    public int amount;
    public int difficultyRequired;
    public double chance;
    public DifficultyMode difficultyMode;
    public ChanceMode chanceMode;

    public Drop(class_2960 itemId, int amount, int difficultyRequired, double chance, DifficultyMode difficultyMode, ChanceMode chanceMode) {
        this.itemId = itemId;
        this.amount = amount;
        this.difficultyRequired = difficultyRequired;
        this.chance = chance;
        this.difficultyMode = difficultyMode;
        this.chanceMode = chanceMode;
    }

    @Nullable
    public static Drop parseLine(String line) {
        ChanceMode chanceMode;
        DifficultyMode difficultyMode;
        String[] split = line.split(",");
        if (split.length != 6) {
            return null;
        }
        class_2960 item = class_2960.method_12829((String)split[0]);
        if (item == null) {
            return null;
        }
        if (!class_7923.field_41178.method_10250(item)) {
            return null;
        }
        if (!NumberUtils.isParsable((String)split[1])) {
            return null;
        }
        int amount = Integer.parseInt(split[1]);
        if (!NumberUtils.isParsable((String)split[2])) {
            return null;
        }
        int difficultyRequired = Integer.parseInt(split[2]);
        if (!NumberUtils.isParsable((String)split[3])) {
            return null;
        }
        double chance = Double.parseDouble(split[3]);
        try {
            difficultyMode = DifficultyMode.valueOf(split[4]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            chanceMode = ChanceMode.valueOf(split[5]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return new Drop(item, amount, difficultyRequired, chance, difficultyMode, chanceMode);
    }

    public static ArrayList<Drop> parseDropsList(List<? extends String> list) {
        ArrayList<Drop> drops = new ArrayList<Drop>();
        for (String string : list) {
            Drop drop = Drop.parseLine(string);
            if (drop == null) continue;
            drops.add(drop);
        }
        return drops;
    }

    public void drop(class_1937 world, class_243 pos, float difficulty) {
        if (this.amount == 0) {
            return;
        }
        if (difficulty < (float)this.difficultyRequired) {
            return;
        }
        double chance = this.chance;
        if (difficulty >= (float)this.difficultyRequired && this.chanceMode == ChanceMode.SCALING) {
            chance *= (double)(difficulty - (float)this.difficultyRequired + 1.0f);
        }
        if (this.difficultyMode == DifficultyMode.MINIMUM) {
            if (RandomHelper.getDouble(world.field_9229, 0.0, 1.0) >= chance) {
                return;
            }
            world.method_8649((class_1297)Drop.createDrop(world, pos, (class_1792)class_7923.field_41178.method_10223(this.itemId), this.amount));
        } else if (this.difficultyMode == DifficultyMode.PER_DIFFICULTY) {
            int tries = (int)(difficulty - (float)this.difficultyRequired + 1.0f);
            if (tries == 0) {
                return;
            }
            int dropped = 0;
            for (int i = 0; i < tries; ++i) {
                if (RandomHelper.getDouble(world.field_9229, 0.0, 1.0) >= chance) continue;
                ++dropped;
                world.method_8649((class_1297)Drop.createDrop(world, pos, (class_1792)class_7923.field_41178.method_10223(this.itemId), this.amount));
            }
            if (this.itemId.equals((Object)class_7923.field_41178.method_10221((Object)ProgressiveBosses.NETHER_STAR_SHARD)) && (double)dropped < (double)difficulty * chance) {
                world.method_8649((class_1297)Drop.createDrop(world, pos, (class_1792)class_7923.field_41178.method_10223(this.itemId), (int)Math.round((double)difficulty * chance - (double)dropped)));
            }
        }
    }

    private static class_1542 createDrop(class_1937 world, class_243 pos, class_1792 item, int amount) {
        class_1542 itemEntity = new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, new class_1799((class_1935)item, amount));
        if (class_7923.field_41178.method_10221((Object)item).equals((Object)class_7923.field_41178.method_10221((Object)ProgressiveBosses.NETHER_STAR_SHARD))) {
            class_2487 compoundNBT = new class_2487();
            itemEntity.method_5652(compoundNBT);
            compoundNBT.method_10575("Health", (short)Short.MAX_VALUE);
            itemEntity.method_5749(compoundNBT);
        }
        return itemEntity;
    }

    public static enum DifficultyMode {
        MINIMUM,
        PER_DIFFICULTY;

    }

    public static enum ChanceMode {
        FLAT,
        SCALING;

    }
}

