/*
 * Decompiled with CFR 0.152.
 */
package productions.digitalcinnamon.minecraft.projectsavethepets;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1657;
import net.minecraft.class_270;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import productions.digitalcinnamon.minecraft.projectsavethepets.CachedUser;

public final class ProjectSaveThePets
implements DedicatedServerModInitializer {
    public static final Map<UUID, String> UUID_TO_PLAYER = new ConcurrentHashMap<UUID, String>();
    public static Logger LOGGER = LogManager.getFormatterLogger((String)"PSTP");

    public static boolean isTeammate(class_270 team, UUID player1, UUID player2) {
        String name1 = UUID_TO_PLAYER.get(player1);
        String name2 = UUID_TO_PLAYER.get(player2);
        return name1 != null && name2 != null && team.method_1204().contains(name1) && team.method_1204().contains(name2);
    }

    public void onInitializeServer() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            if (entity instanceof class_1657) {
                UUID_TO_PLAYER.put(entity.method_5667(), entity.method_5820());
            }
        });
    }

    static {
        try {
            CachedUser[] cachedUsers;
            for (CachedUser cachedUser : cachedUsers = (CachedUser[])new GsonBuilder().create().fromJson((Reader)new FileReader("usercache.json"), CachedUser[].class)) {
                try {
                    UUID_TO_PLAYER.put(UUID.fromString(cachedUser.uuid), cachedUser.name);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.error("Failed to parse UUID in 'usercache.json' (" + cachedUser.uuid + ") (" + cachedUser.name + ")", (Throwable)iae);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error("Failed to find 'usercache.json'", (Throwable)fnfe);
        }
        catch (JsonParseException jpe) {
            LOGGER.error("Failed to parse 'usercache.json'", (Throwable)jpe);
        }
    }
}

