/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import pumpkinpotions.ModBlocks;
import pumpkinpotions.ModDamages;
import pumpkinpotions.ModEffects;
import pumpkinpotions.effect.EffectUpdate;
import pumpkinpotions.effect.GhostEffect;
import pumpkinpotions.render.RuneRender;
import pumpkinpotions.util.EffectUtil;

public class EventListener {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderEntityPre(RenderLivingEvent.Pre<?, ?> event) {
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer buffer = event.getBuffers();
        EffectUtil.whenEffect((LivingEntity)Minecraft.func_71410_x().field_71439_g, ModEffects.mobDizziness, (effect, level) -> {
            Random random = new Random(event.getEntity().func_110124_au().getLeastSignificantBits());
            double translateX = (random.nextDouble() - 0.5) * (double)(level + 1) / 2.0;
            double translateZ = (random.nextDouble() - 0.5) * (double)(level + 1) / 2.0;
            event.getMatrixStack().func_227861_a_(translateX, 0.0, translateZ);
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderEntityPost(RenderLivingEvent.Post<?, ?> event) {
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer buffer = event.getBuffers();
        EffectUtil.whenEffect(event.getEntity(), ModEffects.deadlyAura, (effect, level) -> RuneRender.renderRunes(event.getEntity(), matrixStack, buffer, Minecraft.func_71410_x(), event.getLight(), OverlayTexture.field_229196_a_, event.getPartialRenderTick(), Math.min(40 + 10 * level, 256)));
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.getPlayer().func_70644_a(ModEffects.ghost) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 10 == 0) {
            GhostEffect.updateEffect(player.func_70644_a(ModEffects.ghost), player);
            EffectUtil.whenEffect((LivingEntity)player, ModEffects.golemAggression, (effect, level) -> {
                int radius = 2 * (level + 1);
                player.func_130014_f_().func_217357_a(GolemEntity.class, new AxisAlignedBB(player.func_226277_ct_() - (double)radius, player.func_226278_cu_() - (double)radius, player.func_226281_cx_() - (double)radius, player.func_226277_ct_() + (double)radius, player.func_226278_cu_() + (double)radius, player.func_226281_cx_() + (double)radius)).forEach(golem -> golem.func_70624_b((LivingEntity)player));
            });
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living.field_70173_aa % 10 == 0) {
            EffectUtil.whenEffect(living, ModEffects.randomTeleport, (effect, level) -> EffectUpdate.randomTeleport(living, (float)(level + 1) / 20.0f));
            EffectUtil.whenEffect(living, ModEffects.deadlyAura, (effect, level) -> {
                DamageSource damage = ModDamages.createAuraDamage(living);
                living.func_130014_f_().func_72839_b((Entity)living, new AxisAlignedBB(living.func_226277_ct_() - 2.0, living.func_226278_cu_() - 2.0, living.func_226281_cx_() - 2.0, living.func_226277_ct_() + 2.0, living.func_226278_cu_() + 2.0, living.func_226281_cx_() + 2.0)).forEach(entity -> {
                    if (!(!(entity instanceof LivingEntity) || entity instanceof TameableEntity && ((TameableEntity)entity).func_152114_e(living))) {
                        entity.func_70097_a(damage, (float)(level + 1) / 2.0f);
                    }
                });
            });
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void inputUpdate(InputUpdateEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(ModEffects.confusion)) {
            MovementInput mi = event.getMovementInput();
            boolean w = mi.field_187255_c;
            boolean a = mi.field_187257_e;
            boolean shift = mi.field_228350_h_;
            mi.field_187255_c = mi.field_187256_d;
            mi.field_187257_e = mi.field_187258_f;
            mi.field_228350_h_ = mi.field_78901_c;
            mi.field_187256_d = w;
            mi.field_187258_f = a;
            mi.field_78901_c = shift;
            mi.field_192832_b = -mi.field_192832_b;
            mi.field_78902_a = -mi.field_78902_a;
        }
    }

    @SubscribeEvent
    public void damage(LivingAttackEvent event) {
        if (event.getEntityLiving().func_70644_a(ModEffects.projectileResistance) && event.getSource().func_76352_a()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void xpPickup(PlayerXpEvent.PickupXp event) {
        EffectUtil.whenEffect((LivingEntity)event.getPlayer(), ModEffects.xpBoost, (effect, level) -> {
            double factor = 1.0 + (double)(level + 1) / 3.0;
            event.getOrb().field_70530_e = (int)Math.round((double)event.getOrb().field_70530_e * factor);
        });
    }

    @SubscribeEvent
    public void itemCrafter(PlayerEvent.ItemCraftedEvent event) {
        ServerPlayerEntity player;
        IWorldInfo info;
        if (event.getCrafting().func_77973_b() == ModBlocks.cauldron.func_199767_j() && event.getPlayer() instanceof ServerPlayerEntity && (info = (player = (ServerPlayerEntity)event.getPlayer()).func_71121_q().func_72912_H()) instanceof ServerWorldInfo) {
            ((ServerWorldInfo)info).func_76068_b(18000L);
        }
    }
}

