/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.base;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import pumpkinpotions.base.BlockBase;
import pumpkinpotions.base.TileEntityBase;

public class BlockTE<T extends TileEntityBase>
extends BlockBase {
    private final Class<T> teClass;
    private final Constructor<T> teCtor;
    private final TileEntityType<T> teType;

    public BlockTE(Class<T> teClass, AbstractBlock.Properties properties) {
        this(teClass, properties, new Item.Properties());
    }

    public BlockTE(Class<T> teClass, AbstractBlock.Properties properties, Item.Properties itemProperties) {
        super(properties, itemProperties);
        this.teClass = teClass;
        try {
            this.teCtor = teClass.getConstructor(TileEntityType.class);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Could not get constructor for tile entity " + teClass + ".", e);
        }
        this.teType = new TileEntityType(() -> {
            try {
                return (TileEntityBase)((Object)((Object)this.teCtor.newInstance(this.getTileType())));
            }
            catch (ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                throw new RuntimeException("Could not create TileEntity of type " + teClass + ".", e);
            }
        }, (Set)ImmutableSet.of((Object)this), null);
    }

    @Override
    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.builder().addAll(super.getAdditionalRegisters()).add(this.teType).build();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public T createTileEntity(BlockState state, IBlockReader world) {
        return (T)((Object)((TileEntityBase)this.teType.func_200968_a()));
    }

    public T getTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !this.teClass.isAssignableFrom(te.getClass())) {
            throw new IllegalStateException("Expected a tile entity of type " + this.teClass + " at " + world + " " + pos + ", got" + te);
        }
        return (T)((Object)((TileEntityBase)te));
    }

    public TileEntityType<T> getTileType() {
        return this.teType;
    }
}

