/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.brew;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import pumpkinpotions.brew.Affinity;

public class AffinityTable {
    public static final AffinityTable EMPTY = AffinityTable.builder().build();
    private final Map<Affinity, Double> amplifier;
    private final Map<Affinity, Double> duration;

    private AffinityTable(ImmutableMap<Affinity, Double> amplifier, ImmutableMap<Affinity, Double> duration) {
        this.amplifier = amplifier;
        this.duration = duration;
    }

    public double amplifier(Affinity affinity) {
        return this.amplifier.getOrDefault((Object)affinity, 0.0);
    }

    public double duration(Affinity affinity) {
        return this.duration.getOrDefault((Object)affinity, 0.0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Affinity, Double> amplifier = new HashMap<Affinity, Double>();
        private final Map<Affinity, Double> duration = new HashMap<Affinity, Double>();

        public Builder amplifier(Affinity affinity, double modifier) {
            this.amplifier.put(affinity, modifier);
            return this;
        }

        public Builder duration(Affinity affinity, double modifier) {
            this.duration.put(affinity, modifier);
            return this;
        }

        public Builder both(Affinity affinity, double amplifier, double duration) {
            this.amplifier.put(affinity, amplifier);
            this.duration.put(affinity, duration);
            return this;
        }

        public AffinityTable build() {
            return new AffinityTable(ImmutableMap.copyOf(this.amplifier), ImmutableMap.copyOf(this.duration));
        }
    }
}

