/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.brew;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import pumpkinpotions.ModEffects;
import pumpkinpotions.brew.Affinity;
import pumpkinpotions.brew.AffinityTable;
import pumpkinpotions.brew.BrewData;
import pumpkinpotions.brew.ItemAffinities;
import pumpkinpotions.brew.ItemBrew;
import pumpkinpotions.brew.PotionAlignment;
import pumpkinpotions.cauldron.ColorData;

public class Brew {
    public static final Map<Effect, BrewData> EFFECT_DATA = ImmutableMap.builder().put((Object)Effects.field_76424_c, (Object)new BrewData(Effects.field_76421_d, 7, 24000, Items.field_151102_aT, AffinityTable.builder().amplifier(Affinity.AIR, 1.0).amplifier(Affinity.EARTH, -1.0).duration(Affinity.LANDSCAPE, 1.0).duration(Affinity.CAVE, -1.0).both(Affinity.DRY, 0.5, -0.5).both(Affinity.WET, -0.5, 0.5))).put((Object)Effects.field_76421_d, (Object)new BrewData(Effects.field_76424_c, 5, 12000, Items.field_221672_ax, AffinityTable.builder().amplifier(Affinity.AIR, -1.0).amplifier(Affinity.EARTH, 1.0).duration(Affinity.LANDSCAPE, -1.0).duration(Affinity.CAVE, 1.0).both(Affinity.DRY, -0.5, 0.5).both(Affinity.WET, 0.5, -0.5))).put((Object)Effects.field_76422_e, (Object)new BrewData(Effects.field_76419_f, 9, 24000, Items.field_185158_cP, AffinityTable.builder().amplifier(Affinity.MINE, 1.0).amplifier(Affinity.CRAFT, -1.0).duration(Affinity.TREASURE, 1.0).duration(Affinity.TRASH, -1.0).both(Affinity.HOT, 0.5, -0.5).both(Affinity.COLD, -0.5, 0.5))).put((Object)Effects.field_76419_f, (Object)new BrewData(Effects.field_76422_e, 2, 6000, Items.field_221648_al, AffinityTable.builder().amplifier(Affinity.MINE, -1.0).amplifier(Affinity.CRAFT, 1.0).duration(Affinity.TREASURE, -1.0).duration(Affinity.TRASH, 1.0).both(Affinity.HOT, -0.5, 0.5).both(Affinity.COLD, 0.5, -0.5))).put((Object)Effects.field_76420_g, (Object)new BrewData(Effects.field_76437_t, 9, 24000, Items.field_151065_br, AffinityTable.builder().amplifier(Affinity.POWER, 1.0).amplifier(Affinity.WEAK, -1.0).duration(Affinity.FIRE, 1.0).duration(Affinity.WATER, -1.0).both(Affinity.END, 0.5, -0.5).both(Affinity.HELL, -0.5, 0.5))).put((Object)Effects.field_76432_h, (Object)new BrewData(Effects.field_76433_i, 4, 0, Items.field_151060_bw, AffinityTable.builder().amplifier(Affinity.POWER, 1.0).amplifier(Affinity.WEAK, -1.0).amplifier(Affinity.LIGHT, 0.5).amplifier(Affinity.DARK, -0.5))).put((Object)Effects.field_76433_i, (Object)new BrewData(Effects.field_76432_h, 4, 0, Items.field_234737_dp_, AffinityTable.builder().amplifier(Affinity.POWER, -1.0).amplifier(Affinity.WEAK, 1.0).amplifier(Affinity.LIGHT, -0.5).amplifier(Affinity.DARK, 0.5))).put((Object)Effects.field_76430_j, (Object)new BrewData(null, 4, 24000, Items.field_179556_br, AffinityTable.builder().amplifier(Affinity.DRY, 1.0).amplifier(Affinity.WET, -1.0).duration(Affinity.HOT, 1.0).duration(Affinity.COLD, -1.0).both(Affinity.CAVE, 0.5, -0.5).both(Affinity.LANDSCAPE, -0.5, 0.5))).put((Object)Effects.field_76431_k, (Object)new BrewData(null, 0, 3600, Items.field_151170_bI, AffinityTable.builder().duration(Affinity.HELL, 1.0).duration(Affinity.DARK, -1.0).duration(Affinity.LIGHT, 0.75).duration(Affinity.END, -0.75))).put((Object)Effects.field_76428_l, (Object)new BrewData(Effects.field_76436_u, 4, 6000, Items.field_151073_bk, AffinityTable.builder().amplifier(Affinity.POWER, 1.0).amplifier(Affinity.WEAK, -1.0).duration(Affinity.WET, 1.0).duration(Affinity.DRY, -1.0).both(Affinity.CAVE, 0.5, -0.5).both(Affinity.LANDSCAPE, -0.5, 0.5))).put((Object)Effects.field_76429_m, (Object)new BrewData(Effects.field_82731_v, 3, 12000, Items.field_234797_rz_, AffinityTable.builder().amplifier(Affinity.END, 1.0).amplifier(Affinity.HELL, -1.0).duration(Affinity.EARTH, 1.0).duration(Affinity.AIR, -1.0).both(Affinity.POWER, 0.5, -0.5).both(Affinity.WEAK, -0.5, 0.5))).put((Object)Effects.field_76426_n, (Object)new BrewData(null, 0, 24000, Items.field_151064_bs, AffinityTable.builder().duration(Affinity.FIRE, 1.0).duration(Affinity.WATER, -1.0).duration(Affinity.HOT, 0.75).duration(Affinity.COLD, -0.75))).put((Object)Effects.field_76427_o, (Object)new BrewData(null, 0, 24000, Items.field_196089_aZ, AffinityTable.builder().duration(Affinity.FIRE, -1.0).duration(Affinity.WATER, 1.0).duration(Affinity.DRY, -0.75).duration(Affinity.WET, 0.75))).put((Object)Effects.field_76441_p, (Object)new BrewData(null, 0, 24000, Items.field_221650_am, AffinityTable.builder().duration(Affinity.DARK, 1.0).duration(Affinity.LIGHT, -1.0).duration(Affinity.WEAK, 0.5).duration(Affinity.POWER, -0.5))).put((Object)Effects.field_76440_q, (Object)new BrewData(Effects.field_76439_r, 0, 3600, Items.field_196136_br, AffinityTable.builder().duration(Affinity.DARK, 1.0).duration(Affinity.HELL, -1.0).duration(Affinity.END, 0.75).duration(Affinity.LIGHT, -0.75))).put((Object)Effects.field_76439_r, (Object)new BrewData(Effects.field_76440_q, 0, 24000, Items.field_151150_bK, AffinityTable.builder().duration(Affinity.DARK, -1.0).duration(Affinity.LIGHT, 1.0).duration(Affinity.CAVE, 0.5).duration(Affinity.LANDSCAPE, -0.5))).put((Object)Effects.field_76438_s, (Object)new BrewData(Effects.field_76443_y, 49, 6000, Items.field_151078_bh, AffinityTable.builder().amplifier(Affinity.CAVE, 1.0).amplifier(Affinity.LANDSCAPE, -1.0).duration(Affinity.MINE, 1.0).duration(Affinity.CRAFT, -1.0).both(Affinity.HOT, 0.5, -0.5).both(Affinity.COLD, -0.5, 0.5))).put((Object)Effects.field_76437_t, (Object)new BrewData(Effects.field_76420_g, 1, 6000, Items.field_151071_bq, AffinityTable.builder().amplifier(Affinity.POWER, -1.0).amplifier(Affinity.WEAK, 1.0).duration(Affinity.FIRE, -1.0).duration(Affinity.WATER, 1.0).both(Affinity.END, -0.5, 0.5).both(Affinity.HELL, 0.5, -0.5))).put((Object)Effects.field_76436_u, (Object)new BrewData(Effects.field_76428_l, 3, 3600, Items.field_151070_bp, AffinityTable.builder().amplifier(Affinity.POWER, -1.0).amplifier(Affinity.WEAK, 1.0).duration(Affinity.WET, -1.0).duration(Affinity.DRY, 1.0).both(Affinity.CAVE, -0.5, 0.5).both(Affinity.LANDSCAPE, 0.5, -0.5))).put((Object)Effects.field_82731_v, (Object)new BrewData(Effects.field_76429_m, 3, 3600, Items.field_221690_bg, AffinityTable.builder().amplifier(Affinity.END, -1.0).amplifier(Affinity.HELL, 1.0).duration(Affinity.EARTH, -1.0).duration(Affinity.AIR, 1.0).both(Affinity.POWER, -0.5, 0.5).both(Affinity.WEAK, 0.5, -0.5))).put((Object)Effects.field_180152_w, (Object)new BrewData(null, 9, 12000, Items.field_222070_lD, AffinityTable.builder().amplifier(Affinity.HELL, 1.0).amplifier(Affinity.END, -1.0).duration(Affinity.TRASH, 1.0).duration(Affinity.TREASURE, -1.0).both(Affinity.WATER, 0.5, -0.5).both(Affinity.FIRE, -0.5, 0.5))).put((Object)Effects.field_76444_x, (Object)new BrewData(null, 9, 24000, Items.field_151153_ao, AffinityTable.builder().amplifier(Affinity.HELL, -1.0).amplifier(Affinity.END, 1.0).duration(Affinity.TRASH, -1.0).duration(Affinity.TREASURE, 1.0).both(Affinity.WATER, -0.5, 0.5).both(Affinity.FIRE, 0.5, -0.5))).put((Object)Effects.field_76443_y, (Object)new BrewData(Effects.field_76438_s, 19, 0, Items.field_151158_bO, AffinityTable.builder().amplifier(Affinity.CAVE, 1.0).amplifier(Affinity.LANDSCAPE, -1.0).amplifier(Affinity.HOT, 0.5).amplifier(Affinity.COLD, -0.5))).put((Object)Effects.field_188423_x, (Object)new BrewData(null, 0, 24000, Items.field_222111_pQ, AffinityTable.builder().duration(Affinity.LIGHT, 1.0).duration(Affinity.DARK, -1.0).duration(Affinity.WET, -0.5).duration(Affinity.DRY, 0.5))).put((Object)Effects.field_188424_y, (Object)new BrewData(null, 39, 25, Items.field_190930_cZ, AffinityTable.builder().amplifier(Affinity.AIR, 1.0).amplifier(Affinity.EARTH, -1.0).duration(Affinity.ALWAYS, 25.0))).put((Object)Effects.field_188425_z, (Object)new BrewData(Effects.field_189112_A, 29, 24000, Items.field_234719_bC_, AffinityTable.builder().amplifier(Affinity.TREASURE, 1.0).amplifier(Affinity.TRASH, -1.0).duration(Affinity.MINE, 1.0).duration(Affinity.CRAFT, -1.0).both(Affinity.CAVE, -0.5, 0.5).both(Affinity.LANDSCAPE, 0.5, -0.5))).put((Object)Effects.field_189112_A, (Object)new BrewData(Effects.field_188425_z, 19, 12000, Items.field_234718_bB_, AffinityTable.builder().amplifier(Affinity.TREASURE, -1.0).amplifier(Affinity.TRASH, 1.0).duration(Affinity.MINE, -1.0).duration(Affinity.CRAFT, 1.0).both(Affinity.CAVE, 0.5, -0.5).both(Affinity.LANDSCAPE, -0.5, 0.5))).put((Object)Effects.field_204839_B, (Object)new BrewData(null, 0, 6000, Items.field_204840_eX, AffinityTable.builder().amplifier(Affinity.AIR, -1.0).amplifier(Affinity.EARTH, 1.0).duration(Affinity.COLD, 1.0).duration(Affinity.HOT, -1.0).both(Affinity.DRY, -0.5, 0.5).both(Affinity.WET, 0.5, -0.5))).put((Object)Effects.field_205136_C, (Object)new BrewData(null, 0, 6000, Items.field_179563_cD, AffinityTable.builder().duration(Affinity.WATER, 1.0).duration(Affinity.EARTH, -1.0).duration(Affinity.WET, -0.5).duration(Affinity.DRY, 0.5))).put((Object)Effects.field_206827_D, (Object)new BrewData(null, 0, 24000, Items.field_196088_aY, AffinityTable.builder().duration(Affinity.WATER, 1.0).duration(Affinity.AIR, -1.0).duration(Affinity.WET, 0.5).duration(Affinity.DRY, -0.5))).put((Object)Effects.field_220309_E, (Object)new BrewData(Effects.field_220310_F, 5, 288000, Items.field_151166_bC, AffinityTable.builder().amplifier(Affinity.TRASH, 1.0).amplifier(Affinity.TREASURE, -1.0).duration(Affinity.WEAK, 1.0).duration(Affinity.POWER, -1.0).both(Affinity.END, 0.5, -0.5).both(Affinity.HELL, -0.5, 0.5))).put((Object)Effects.field_220310_F, (Object)new BrewData(Effects.field_220309_E, 0, 288000, Items.field_190929_cY, AffinityTable.builder().duration(Affinity.TRASH, 1.0).duration(Affinity.TREASURE, -1.0).duration(Affinity.WEAK, 0.5).duration(Affinity.POWER, 0.5))).put((Object)ModEffects.mobDizziness, (Object)new BrewData(null, 9, 3600, Items.field_151061_bv, AffinityTable.builder().amplifier(Affinity.DARK, 1.0).amplifier(Affinity.LIGHT, -1.0).duration(Affinity.END, 1.0).duration(Affinity.HELL, -1.0).both(Affinity.FIRE, 0.5, -0.5).both(Affinity.WATER, -0.5, 0.5))).put((Object)ModEffects.ghost, (Object)new BrewData(null, 0, 6000, Items.field_222011_iL, AffinityTable.builder().duration(Affinity.AIR, 1.0).duration(Affinity.EARTH, -1.0).duration(Affinity.END, -0.5).duration(Affinity.HELL, 0.5))).put((Object)ModEffects.confusion, (Object)new BrewData(null, 0, 3600, Items.field_234760_kn_, AffinityTable.builder().duration(Affinity.EARTH, 1.0).duration(Affinity.AIR, -1.0).duration(Affinity.HELL, -0.5).duration(Affinity.END, 0.5))).put((Object)ModEffects.golemAggression, (Object)new BrewData(null, 9, 12000, Items.field_221689_cG, AffinityTable.builder().amplifier(Affinity.TREASURE, -1.0).amplifier(Affinity.TRASH, 1.0).duration(Affinity.HELL, -1.0).duration(Affinity.END, 1.0).both(Affinity.COLD, -0.5, 0.5).both(Affinity.HOT, 0.5, -0.5))).put((Object)ModEffects.randomTeleport, (Object)new BrewData(null, 9, 3600, Items.field_151079_bi, AffinityTable.builder().amplifier(Affinity.END, 1.0).amplifier(Affinity.WATER, -1.0).duration(Affinity.FIRE, 1.0).duration(Affinity.HELL, -1.0))).put((Object)ModEffects.projectileResistance, (Object)new BrewData(ModEffects.deadlyAura, 0, 12000, Items.field_185159_cQ, AffinityTable.builder().duration(Affinity.POWER, -0.75).duration(Affinity.WEAK, 0.75).duration(Affinity.DARK, -0.75).duration(Affinity.LIGHT, -0.75).both(Affinity.AIR, -0.25, 0.25).both(Affinity.EARTH, 0.25, -0.25))).put((Object)ModEffects.deadlyAura, (Object)new BrewData(ModEffects.projectileResistance, 9, 6000, Items.field_185166_h, AffinityTable.builder().amplifier(Affinity.POWER, 1.0).amplifier(Affinity.WEAK, -1.0).duration(Affinity.DARK, 1.0).duration(Affinity.LIGHT, -1.0).both(Affinity.AIR, 0.5, -0.5).both(Affinity.EARTH, -0.5, 0.5))).put((Object)ModEffects.knockbackResistance, (Object)new BrewData(ModEffects.knockbackBoost, 9, 24000, Items.field_222068_kQ, AffinityTable.builder().amplifier(Affinity.CAVE, 1.0).amplifier(Affinity.LANDSCAPE, -1.0).duration(Affinity.WEAK, 1.0).duration(Affinity.POWER, -1.0).both(Affinity.CRAFT, 0.5, -0.5).both(Affinity.MINE, -0.5, 0.5))).put((Object)ModEffects.knockbackBoost, (Object)new BrewData(ModEffects.knockbackResistance, 9, 12000, Items.field_221774_cw, AffinityTable.builder().amplifier(Affinity.CAVE, -1.0).amplifier(Affinity.LANDSCAPE, 1.0).duration(Affinity.WEAK, -1.0).duration(Affinity.POWER, 1.0).both(Affinity.CRAFT, -0.5, 0.5).both(Affinity.MINE, 0.5, -0.5))).put((Object)ModEffects.xpBoost, (Object)new BrewData(null, 9, 24000, Items.field_151128_bU, AffinityTable.builder().amplifier(Affinity.TREASURE, 1.0).amplifier(Affinity.TRASH, -1.0).duration(Affinity.HELL, 1.0).duration(Affinity.END, -1.0).both(Affinity.COLD, 0.5, -0.5).both(Affinity.HOT, -0.5, 0.5))).build();
    public static final Set<Item> FOCI = ImmutableSet.of((Object)Items.field_151137_ax, (Object)Items.field_151114_aO, (Object)Items.field_151016_H, (Object)Items.field_185157_bK);
    public static final Set<Item> EFFECT_ITEMS = (Set)EFFECT_DATA.values().stream().map(data -> data.item).collect(ImmutableSet.toImmutableSet());

    public static ItemStack getPotion(List<ItemStack> inputs) {
        List items = inputs.stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
        Item potionItem = Items.field_151068_bn;
        PotionAlignment alignment = PotionAlignment.NORMAL;
        for (Item item2 : items.stream().filter(FOCI::contains).collect(Collectors.toList())) {
            if (item2 == Items.field_151016_H && potionItem != Items.field_185156_bI) {
                potionItem = Items.field_185155_bH;
                continue;
            }
            if (item2 == Items.field_185157_bK) {
                potionItem = Items.field_185156_bI;
                continue;
            }
            if (item2 == Items.field_151137_ax) {
                alignment = PotionAlignment.LONG;
                continue;
            }
            if (item2 != Items.field_151114_aO) continue;
            alignment = PotionAlignment.STRONG;
        }
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        Effect current = null;
        BrewData data = null;
        double duration = 0.0;
        double amplifier = 0.0;
        double affinityMultiplier = 1.0;
        for (Item item3 : items.stream().filter(item -> !FOCI.contains(item)).collect(Collectors.toList())) {
            if (EFFECT_ITEMS.contains(item3)) {
                if (current != null) {
                    effects.add(alignment.finishEffect(current, data, duration, amplifier));
                    current = null;
                }
                duration = (data = EFFECT_DATA.get(current = (Effect)EFFECT_DATA.entrySet().stream().filter(entry -> ((BrewData)entry.getValue()).item == item3).findFirst().map(Map.Entry::getKey).orElse(null))) == null ? 0.0 : Math.max(40.0, (double)data.maxDuration / 20.0);
                amplifier = data == null ? 0.0 : Math.min(2.0, Math.floor((double)(data.maxLevel - 1) / 2.0));
                affinityMultiplier = 1.0;
                continue;
            }
            if (!ItemBrew.EFFECT_DATA.containsKey(item3) || current == null || data == null) continue;
            ItemAffinities affinites = ItemBrew.EFFECT_DATA.get(item3);
            amplifier += affinityMultiplier * data.affinities.amplifier(affinites.affinity1) * affinites.power * (double)data.maxLevel / 70.0;
            duration += affinityMultiplier * data.affinities.duration(affinites.affinity1) * affinites.power * (double)data.maxDuration / 70.0;
            if (affinites.affinity2 != null) {
                amplifier += affinityMultiplier * 0.7 * data.affinities.amplifier(affinites.affinity2) * affinites.power * (double)data.maxLevel / 70.0;
                duration += affinityMultiplier * 0.7 * data.affinities.duration(affinites.affinity2) * affinites.power * (double)data.maxDuration / 70.0;
            }
            if (affinites.affinity3 != null) {
                amplifier += affinityMultiplier * 0.4 * data.affinities.amplifier(affinites.affinity3) * affinites.power * (double)data.maxLevel / 70.0;
                duration += affinityMultiplier * 0.4 * data.affinities.duration(affinites.affinity3) * affinites.power * (double)data.maxDuration / 70.0;
            }
            affinityMultiplier = affinityMultiplier * 2.0 / 3.0;
        }
        if (current != null) {
            effects.add(alignment.finishEffect(current, data, duration, amplifier));
            current = null;
        }
        ItemStack potion = new ItemStack((IItemProvider)potionItem);
        if (effects.isEmpty()) {
            return PotionUtils.func_185188_a((ItemStack)potion, (Potion)Potions.field_185233_e);
        }
        int color = PotionUtils.func_185181_a(effects);
        potion.func_200302_a((ITextComponent)new TranslationTextComponent("item.pumpkinpotions." + potionItem.getRegistryName().func_110623_a()).func_240699_a_(TextFormatting.RESET).func_240699_a_(TextFormatting.GREEN));
        CompoundNBT nbt = potion.func_196082_o();
        nbt.func_74768_a("CustomPotionColor", color);
        potion.func_77982_d(nbt);
        return PotionUtils.func_185184_a((ItemStack)potion, effects);
    }

    public static boolean canAccept(ItemStack stack, List<ItemStack> items) {
        block10: {
            block9: {
                if (stack.func_77973_b() == Items.field_151075_bm) {
                    return false;
                }
                if (FOCI.contains(stack.func_77973_b())) {
                    if (Brew.hasItem(stack.func_77973_b(), items)) {
                        return false;
                    }
                    if (stack.func_77973_b() == Items.field_185157_bK) {
                        return Brew.hasItem(Items.field_151016_H, items);
                    }
                    if (stack.func_77973_b() == Items.field_151137_ax) {
                        return !Brew.hasItem(Items.field_151114_aO, items);
                    }
                    if (stack.func_77973_b() == Items.field_151114_aO) {
                        return !Brew.hasItem(Items.field_151137_ax, items);
                    }
                    return true;
                }
                if (EFFECT_ITEMS.contains(stack.func_77973_b())) break block9;
                if (!ItemBrew.EFFECT_DATA.containsKey(stack.func_77973_b())) break block10;
                if (!items.stream().map(ItemStack::func_77973_b).anyMatch(EFFECT_ITEMS::contains)) break block10;
            }
            return !Brew.hasItem(stack.func_77973_b(), items);
        }
        return false;
    }

    public static void applyColors(ItemStack stack, ColorData colors) {
        EFFECT_DATA.entrySet().stream().filter(entry -> ((BrewData)entry.getValue()).item == stack.func_77973_b()).findFirst().ifPresent(entry -> colors.applyColor(((Effect)entry.getKey()).func_76401_j()));
    }

    private static boolean hasItem(Item item, List<ItemStack> items) {
        return items.stream().map(ItemStack::func_77973_b).anyMatch(elem -> elem == item);
    }
}

