/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.brew;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pumpkinpotions.brew.Affinity;

public class ItemAffinities {
    public static final double MAX_POWER = 70.0;
    public final double power;
    @Nonnull
    public final Affinity affinity1;
    @Nullable
    public final Affinity affinity2;
    @Nullable
    public final Affinity affinity3;

    private ItemAffinities(double power, @Nonnull Affinity affinity1, @Nullable Affinity affinity2, @Nullable Affinity affinity3) {
        this.power = power;
        this.affinity1 = affinity1;
        this.affinity2 = affinity2;
        this.affinity3 = affinity3;
    }

    public static ItemAffinities insane(Affinity ... affinities) {
        return ItemAffinities.create(50.0, affinities);
    }

    public static ItemAffinities ultraStrong(Affinity ... affinities) {
        return ItemAffinities.create(30.0, affinities);
    }

    public static ItemAffinities veryStrong(Affinity ... affinities) {
        return ItemAffinities.create(25.0, affinities);
    }

    public static ItemAffinities strong(Affinity ... affinities) {
        return ItemAffinities.create(20.0, affinities);
    }

    public static ItemAffinities decent(Affinity ... affinities) {
        return ItemAffinities.create(15.0, affinities);
    }

    public static ItemAffinities normal(Affinity ... affinities) {
        return ItemAffinities.create(10.0, affinities);
    }

    public static ItemAffinities weak(Affinity ... affinities) {
        return ItemAffinities.create(5.0, affinities);
    }

    private static ItemAffinities create(double power, Affinity[] affinities) {
        if (affinities.length < 1 || affinities.length > 3) {
            throw new IllegalArgumentException("Invalid amount of affinities given");
        }
        if (affinities.length == 1) {
            return new ItemAffinities(power, affinities[0], null, null);
        }
        if (affinities.length == 2) {
            return new ItemAffinities(power, affinities[0], affinities[1], null);
        }
        return new ItemAffinities(power, affinities[0], affinities[1], affinities[2]);
    }
}

