/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.cauldron;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Triple;
import pumpkinpotions.book.BookHandler;
import pumpkinpotions.cauldron.TileCauldron;
import pumpkinpotions.util.RenderUtil;

public class RenderCauldron
extends TileEntityRenderer<TileCauldron> {
    public static final int TICKS_PER_QUARTER = 100;
    public static final RenderType LECTERN_EFFECT = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("pumpkinpotions", "textures/lectern_effect.png"));

    public RenderCauldron(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(@Nonnull TileCauldron tile, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int light, int overlay) {
        if (tile.getFill().full) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.796875, 0.0);
            this.renderPotion(matrixStack, buffer, tile.colorData.getColor1(), tile.colorData.getColor2(), tile.colorData.getColor3(), tile.colorData.getColor4(), partialTicks, light);
            matrixStack.func_227865_b_();
        }
        for (Direction dir : Direction.values()) {
            TileEntity lectern;
            if (dir.func_96559_d() != 0) continue;
            BlockPos pos = tile.func_174877_v().func_185334_h().func_177972_a(dir);
            BlockState state = tile.func_145831_w().func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_222428_lQ || !((lectern = tile.func_145831_w().func_175625_s(pos)) instanceof LecternTileEntity)) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)dir.func_82601_c(), 0.0, (double)dir.func_82599_e());
            this.renderLectern(matrixStack, buffer, tile, (LecternTileEntity)lectern, partialTicks, light);
            matrixStack.func_227865_b_();
        }
    }

    private void renderPotion(MatrixStack matrixStack, IRenderTypeBuffer buffer, int color1, int color2, int color3, int color4, float partialTicks, int light) {
        float ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
        float partQ = ticks % 100.0f / 100.0f;
        Triple<Float, Float, Float> b12 = RenderUtil.blendRGB(color1, color2, partQ);
        Triple<Float, Float, Float> b23 = RenderUtil.blendRGB(color2, color3, partQ);
        Triple<Float, Float, Float> b34 = RenderUtil.blendRGB(color3, color4, partQ);
        Triple<Float, Float, Float> b41 = RenderUtil.blendRGB(color4, color1, partQ);
        int direction = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 400 / 100;
        if (direction > 0) {
            for (int i = 0; i < direction; ++i) {
                Triple<Float, Float, Float> tmp = b12;
                b12 = b23;
                b23 = b34;
                b34 = b41;
                b41 = tmp;
            }
        }
        float alpha = 1.0f - ticks % 40.0f / 40.0f * 0.05f;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(Fluids.field_204546_a.getAttributes().getStillTexture());
        Matrix4f model = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
        IVertexBuilder vertex = buffer.getBuffer(RenderType.func_228647_g_());
        vertex.func_227888_a_(model, 0.125f, 0.0f, 0.875f).func_227885_a_(((Float)b12.getLeft()).floatValue(), ((Float)b12.getMiddle()).floatValue(), ((Float)b12.getRight()).floatValue(), alpha).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(16.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.875f, 0.0f, 0.875f).func_227885_a_(((Float)b23.getLeft()).floatValue(), ((Float)b23.getMiddle()).floatValue(), ((Float)b23.getRight()).floatValue(), alpha).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(16.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.875f, 0.0f, 0.125f).func_227885_a_(((Float)b34.getLeft()).floatValue(), ((Float)b34.getMiddle()).floatValue(), ((Float)b34.getRight()).floatValue(), alpha).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(0.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.125f, 0.0f, 0.125f).func_227885_a_(((Float)b41.getLeft()).floatValue(), ((Float)b41.getMiddle()).floatValue(), ((Float)b41.getRight()).floatValue(), alpha).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(0.0)).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
    }

    private void renderLectern(MatrixStack matrixStack, IRenderTypeBuffer buffer, TileCauldron tile, LecternTileEntity lectern, float partialTicks, int light) {
        if (!tile.getFill().full || !((Boolean)lectern.func_145831_w().func_180495_p(lectern.func_174877_v()).func_177229_b((Property)BlockStateProperties.field_222515_o)).booleanValue()) {
            return;
        }
        ItemStack book = lectern.func_214033_c();
        if (book.func_190926_b()) {
            return;
        }
        List<ItemStack> bookStacks = BookHandler.getStacks(book);
        if (bookStacks.isEmpty()) {
            return;
        }
        if (tile.getFill() == TileCauldron.FillState.WATER) {
            this.renderLecternItem(new ItemStack((IItemProvider)Items.field_151075_bm), matrixStack, buffer, partialTicks, light, (float)tile.getPickupCooldown() / 40.0f);
        } else {
            List<ItemStack> stacks = tile.getPotionItems();
            if (stacks.size() > bookStacks.size()) {
                this.renderLecternItem(new ItemStack((IItemProvider)Items.field_221803_eL), matrixStack, buffer, partialTicks, light, 0.0f);
            } else {
                for (int i = 0; i < stacks.size(); ++i) {
                    if (stacks.get(i).func_77973_b() == bookStacks.get(i).func_77973_b()) continue;
                    this.renderLecternItem(new ItemStack((IItemProvider)Items.field_221803_eL), matrixStack, buffer, partialTicks, light, 0.0f);
                    return;
                }
                if (bookStacks.size() > stacks.size()) {
                    this.renderLecternItem(bookStacks.get(stacks.size()), matrixStack, buffer, partialTicks, light, (float)tile.getPickupCooldown() / 40.0f);
                }
            }
        }
    }

    private void renderLecternGlint(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, int light, float open) {
        open = 1.0f - open;
        float ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
        float alpha = 0.3f + 0.4f * (float)Math.abs(Math.sin(ticks / 20.0f));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.75 + (double)open * 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-ticks));
        Matrix4f model = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
        IVertexBuilder vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.5f, open * 0.4f, open * -0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.5f, open * 0.4f, open * 0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.5f, open * 0.4f, open * -0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.5f, open * 0.4f, open * 0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.125f, open * 0.4f, open * 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.125f, open * 0.4f, open * 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.125f, open * 0.4f, open * -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.125f, open * 0.4f, open * -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.5f, open * 0.4f, open * 0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.125f, open * 0.4f, open * 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.5f, open * 0.4f, open * -0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * 0.125f, open * 0.4f, open * -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.5f, open * 0.4f, open * 0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.125f, open * 0.4f, open * 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex = buffer.getBuffer(LECTERN_EFFECT);
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.5f, open * 0.4f, open * -0.125f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertex.func_227888_a_(model, open * -0.125f, open * 0.4f, open * -0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
        matrixStack.func_227865_b_();
    }

    private void renderLecternItem(ItemStack item, MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, int light, float open) {
        open = 1.0f - open;
        float ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.25 + (double)open * 0.2, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ticks));
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        matrixStack.func_227862_a_(open, open, open);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(item, ItemCameraTransforms.TransformType.GROUND, light, OverlayTexture.field_229196_a_, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }

    public boolean isGlobalRenderer(@Nonnull TileCauldron tile) {
        return true;
    }
}

