/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.cauldron;

import java.time.Month;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import pumpkinpotions.base.TileEntityBase;
import pumpkinpotions.book.BookHandler;
import pumpkinpotions.brew.Brew;
import pumpkinpotions.cauldron.ColorData;
import pumpkinpotions.util.Util;

public class TileCauldron
extends TileEntityBase
implements ITickableTileEntity {
    public static final int MAX_PICKUP_COOLDOWN = 40;
    private int pickupCooldown = 0;
    private FillState fill = FillState.EMPTY;
    private final List<ItemStack> potionItems = new ArrayList<ItemStack>();
    public final ColorData colorData = new ColorData();

    public TileCauldron(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            if (this.field_145850_b.field_72995_K && this.fill == FillState.POTION) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.2;
                double y = (double)this.field_174879_c.func_177956_o() + 0.8;
                double z = (double)this.field_174879_c.func_177952_p() + 0.2;
                Util.addParticle(this.field_145850_b, (IParticleData)ParticleTypes.field_197625_r, x + this.field_145850_b.field_73012_v.nextDouble() * 0.6, y, z + this.field_145850_b.field_73012_v.nextDouble() * 0.6, 0.0, 0.1, 0.0, this.colorData.getRandomColor(this.field_145850_b.field_73012_v));
            }
            if (this.pickupCooldown > 0) {
                --this.pickupCooldown;
                this.func_70296_d();
            } else if (!this.field_145850_b.field_72995_K && this.fill.full) {
                List itemsOnGround = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
                for (ItemEntity entity : itemsOnGround) {
                    ItemStack stack;
                    if (entity.field_145804_b >= 5 || (stack = entity.func_92059_d()).func_190916_E() < 1) continue;
                    if (this.fill.full && stack.func_77973_b() == Items.field_151103_aS && stack.func_200301_q().func_150261_e().equalsIgnoreCase("Oh Spooky")) {
                        stack.func_190918_g(1);
                        entity.func_92058_a(stack);
                        ZonedDateTime zdt = ZonedDateTime.now();
                        boolean halloween = zdt.getDayOfMonth() == 31 && zdt.getMonth() == Month.OCTOBER;
                        for (int i = 0; i < (halloween ? 50 : 1); ++i) {
                            BatEntity bat = (BatEntity)EntityType.field_200791_e.func_200721_a(this.field_145850_b);
                            if (bat == null) continue;
                            bat.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.4, (double)this.field_174879_c.func_177956_o() + 1.4, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
                            if (halloween) {
                                bat.func_200203_b((ITextComponent)new TranslationTextComponent("pumpkinpotions.itshalloween"));
                                bat.func_174805_g(true);
                                bat.func_110163_bv();
                            }
                            this.field_145850_b.func_217376_c((Entity)bat);
                            bat.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.4, (double)this.field_174879_c.func_177956_o() + 1.4, (double)this.field_174879_c.func_177952_p() + 0.5);
                        }
                        continue;
                    }
                    if (this.fill == FillState.WATER) {
                        if (stack.func_77973_b() != Items.field_151075_bm) continue;
                        stack.func_190918_g(1);
                        entity.func_92058_a(stack);
                        this.fill = FillState.POTION;
                        this.colorData.reset();
                        this.pickupCooldown = 40;
                        this.func_70296_d();
                        Util.playSound(this.field_145850_b, null, SoundEvents.field_187621_J, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
                        break;
                    }
                    if (!Brew.canAccept(stack, this.potionItems)) continue;
                    ItemStack newStack = stack.func_77979_a(1);
                    entity.func_92058_a(stack);
                    this.potionItems.add(newStack);
                    Brew.applyColors(newStack, this.colorData);
                    this.pickupCooldown = 40;
                    this.func_70296_d();
                    Util.playSound(this.field_145850_b, null, SoundEvents.field_187621_J, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    public ActionResult<ItemStack> handleItemClick(PlayerEntity player, ItemStack stack) {
        ItemStack potion;
        if (stack.func_77973_b() == Items.field_151069_bo && this.fill == FillState.POTION && !(potion = Brew.getPotion(this.potionItems)).func_190926_b()) {
            this.fill = FillState.EMPTY;
            this.colorData.reset();
            this.pickupCooldown = 0;
            this.func_70296_d();
            Util.playSound(this.field_145850_b, player, SoundEvents.field_187615_H, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)potion);
        }
        if (stack.func_77973_b() == Items.field_151122_aG && this.fill == FillState.EMPTY && !this.potionItems.isEmpty()) {
            Util.playSound(this.field_145850_b, player, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, this.field_174879_c, 2.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)BookHandler.getBook(player, this.potionItems));
        }
        Optional fluidHandlerCap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve();
        if (fluidHandlerCap.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)fluidHandlerCap.get();
            if (this.fill.full) {
                int filled = fluidHandler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE);
                if (filled >= 1000) {
                    if (!player.func_184812_l_()) {
                        fluidHandler.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.fill = FillState.EMPTY;
                    this.potionItems.clear();
                    this.colorData.reset();
                    this.pickupCooldown = 0;
                    this.func_70296_d();
                    Util.playSound(this.field_145850_b, player, SoundEvents.field_187630_M, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
                    return ActionResult.func_226248_a_((Object)fluidHandler.getContainer());
                }
            } else {
                int drained = fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE).getAmount();
                if (drained >= 1000) {
                    if (!player.func_184812_l_()) {
                        fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.fill = FillState.WATER;
                    this.potionItems.clear();
                    this.colorData.reset();
                    this.pickupCooldown = 40;
                    this.func_70296_d();
                    Util.playSound(this.field_145850_b, player, SoundEvents.field_187624_K, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f);
                    return ActionResult.func_226248_a_((Object)fluidHandler.getContainer());
                }
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public List<ItemStack> getPotionItems() {
        return Collections.unmodifiableList(this.potionItems);
    }

    public FillState getFill() {
        return this.fill;
    }

    public int getPickupCooldown() {
        return this.pickupCooldown;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b("fill", 8)) {
            try {
                this.fill = FillState.valueOf(nbt.func_74779_i("fill"));
            }
            catch (IllegalArgumentException e) {
                this.fill = FillState.EMPTY;
            }
        } else {
            this.fill = FillState.EMPTY;
        }
        this.potionItems.clear();
        if (nbt.func_150297_b("items", 9)) {
            ListNBT items = nbt.func_150295_c("items", 10);
            for (int i = 0; i < items.size(); ++i) {
                this.potionItems.add(ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(i)));
            }
        }
        this.colorData.deserializeNBT(nbt.func_74775_l("colors"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt.func_74778_a("fill", this.fill.name());
        ListNBT items = new ListNBT();
        for (ItemStack stack : this.potionItems) {
            items.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        nbt.func_218657_a("items", (INBT)items);
        nbt.func_218657_a("colors", (INBT)this.colorData.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        if (nbt.func_150297_b("fill", 8)) {
            try {
                this.fill = FillState.valueOf(nbt.func_74779_i("fill"));
            }
            catch (IllegalArgumentException e) {
                this.fill = FillState.EMPTY;
            }
        } else {
            this.fill = FillState.EMPTY;
        }
        this.potionItems.clear();
        if (nbt.func_150297_b("items", 9)) {
            ListNBT items = nbt.func_150295_c("items", 10);
            for (int i = 0; i < items.size(); ++i) {
                this.potionItems.add(ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(i)));
            }
        }
        this.colorData.deserializeNBT(nbt.func_74775_l("colors"));
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74778_a("fill", this.fill.name());
        ListNBT items = new ListNBT();
        for (ItemStack stack : this.potionItems) {
            items.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        nbt.func_218657_a("items", (INBT)items);
        nbt.func_218657_a("colors", (INBT)this.colorData.serializeNBT());
        return nbt;
    }

    public static enum FillState {
        EMPTY(false),
        WATER(true),
        POTION(true);

        public final boolean full;

        private FillState(boolean full) {
            this.full = full;
        }
    }
}

