/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
    }

    @Nonnull
    public String func_200397_b() {
        return "PumpkinPotions block loot tables";
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block b : Registry.field_212618_g) {
            ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)b);
            if (!"pumpkinpotions".equals(id.func_110624_b())) continue;
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular);
            tables.put(id, func.apply(b));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = BlockLootProvider.getPath(this.generator.func_200391_b(), (ResourceLocation)e.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)e.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder genRegular(Block b) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)b);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }
}

