/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.data;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import pumpkinpotions.data.AlwaysExistentModelFile;

public class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private final Set<Item> handheld = new HashSet<Item>();
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public ItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "pumpkinpotions", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "PumpkinPotions item models";
    }

    protected void registerModels() {
        Set items = Registry.field_212630_s.func_201756_e().filter(i -> "pumpkinpotions".equals(Registry.field_212630_s.func_177774_c(i).func_110624_b())).collect(Collectors.toSet());
        this.registerItemBlocks(items.stream().filter(i -> i instanceof BlockItem).map(i -> (BlockItem)i).collect(Collectors.toSet()));
        this.registerItems(items.stream().filter(i -> !(i instanceof BlockItem)).collect(Collectors.toSet()));
    }

    private static String name(Item i) {
        return Registry.field_212630_s.func_177774_c((Object)i).func_110623_a();
    }

    private ItemModelBuilder handheldItem(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", new ResourceLocation("pumpkinpotions", "item/" + name));
    }

    private ItemModelBuilder handheldItem(Item i) {
        this.handheld.add(i);
        return this.handheldItem(ItemModelProvider.name(i));
    }

    private ItemModelBuilder generatedItem(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", new ResourceLocation("pumpkinpotions", "item/" + name));
    }

    private ItemModelBuilder generatedItem(Item i) {
        return this.generatedItem(ItemModelProvider.name(i));
    }

    private void registerItems(Set<Item> items) {
        items.forEach(item -> {
            if (!(item instanceof BlockItem) && !this.handheld.contains(item)) {
                this.generatedItem((Item)item);
            }
        });
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks) {
        itemBlocks.forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new AlwaysExistentModelFile(new ResourceLocation("pumpkinpotions", "block/" + name)));
        });
    }
}

