/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.network;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import pumpkinpotions.cauldron.TileCauldron;
import pumpkinpotions.network.PacketSerializer;
import pumpkinpotions.network.TeRequestHandler;
import pumpkinpotions.network.TeRequestSerializer;
import pumpkinpotions.network.TeUpdateHandler;
import pumpkinpotions.network.TeUpdateSerializer;

public class PumpkinNetwork {
    private static final String PROTOCOL_VERSION = "2";
    private static int discriminator = 0;
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("pumpkinpotions", "netchannel"), () -> "2", "2"::equals, "2"::equals);

    public static void registerPackets() {
        PumpkinNetwork.register(new TeUpdateSerializer(), () -> TeUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        PumpkinNetwork.register(new TeRequestSerializer(), () -> TeRequestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <T> void register(PacketSerializer<T> serializer, Supplier<BiConsumer<T, Supplier<NetworkEvent.Context>>> handler, NetworkDirection direction) {
        Objects.requireNonNull(direction);
        BiConsumer<T, Supplier<NetworkEvent.Context>> realHandler = direction == NetworkDirection.PLAY_TO_CLIENT || direction == NetworkDirection.LOGIN_TO_CLIENT ? (BiConsumer<T, Supplier<NetworkEvent.Context>>)DistExecutor.unsafeRunForDist(() -> handler, () -> () -> (msg, ctx) -> {}) : handler.get();
        INSTANCE.registerMessage(discriminator++, serializer.messageClass(), serializer::encode, serializer::decode, realHandler, Optional.of(direction));
    }

    public static void updateTE(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            PumpkinNetwork.updateTE(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), world, pos, false);
        }
    }

    public static void updateTE(World world, BlockPos pos, boolean vanilla) {
        if (!world.field_72995_K) {
            PumpkinNetwork.updateTE(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), world, pos, vanilla);
        }
    }

    static void updateTE(PacketDistributor.PacketTarget target, World world, BlockPos pos, boolean vanilla) {
        if (!world.field_72995_K) {
            CompoundNBT nbt;
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return;
            }
            if (te instanceof TileCauldron) {
                for (Direction dir : Direction.values()) {
                    BlockPos newPos;
                    if (dir.func_96559_d() != 0 || world.func_180495_p(newPos = pos.func_185334_h().func_177972_a(dir)).func_177230_c() != Blocks.field_222428_lQ) continue;
                    PumpkinNetwork.updateTE(target, world, newPos, true);
                }
            }
            if ((nbt = vanilla ? te.func_189515_b(new CompoundNBT()) : te.func_189517_E_()) == null) {
                return;
            }
            ResourceLocation id = te.func_200662_C().getRegistryName();
            if (id == null) {
                return;
            }
            INSTANCE.send(target, (Object)new TeUpdateSerializer.TeUpdateMessage(world.func_234923_W_().getRegistryName(), pos, id, nbt));
        }
    }

    public static void requestTE(World world, BlockPos pos) {
        if (world.field_72995_K) {
            INSTANCE.sendToServer((Object)new TeRequestSerializer.TeRequestMessage(world.func_234923_W_().getRegistryName(), pos));
        }
    }
}

