/*
 * Decompiled with CFR 0.152.
 */
package pumpkinpotions.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Pair;

public class RuneRender {
    public static final ResourceLocation RUNES_TEX = new ResourceLocation("pumpkinpotions", "textures/runes.png");
    public static final List<Pair<Float, Float>> TEX_COORDINATES = ImmutableList.of((Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), (Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0f)), (Object)Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.0f)), (Object)Pair.of((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.0f)), (Object)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.25f)), (Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
    public static final float RUNE_SIZE = 0.25f;

    public static void renderRunes(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, Minecraft mc, int light, int overlay, float partialTicks, int runes) {
        Random random = new Random(entity.func_110124_au().getMostSignificantBits());
        double width = entity.func_213311_cf();
        double radius = width / 2.0 + 0.2;
        for (int i = 0; i < runes; ++i) {
            double y = random.nextDouble() * (double)entity.func_213302_cg();
            float angleAdd = 360.0f * random.nextFloat();
            float spinSpeed = (0.5f + random.nextFloat()) * (float)(random.nextBoolean() ? 1 : -1);
            float size = random.nextFloat() * 0.1f + 0.08f;
            double distance = (1.0 + random.nextDouble() * 0.4) * radius;
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angleAdd + ((float)entity.field_70173_aa + partialTicks) * spinSpeed));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(0.0, -y, distance);
            Pair<Float, Float> coordinates = TEX_COORDINATES.get(random.nextInt(TEX_COORDINATES.size()));
            mc.func_110434_K().func_110577_a(RUNES_TEX);
            Matrix4f model = matrixStack.func_227866_c_().func_227870_a_();
            Matrix3f normal = matrixStack.func_227866_c_().func_227872_b_();
            BufferBuilder vertex = Tessellator.func_178181_a().func_178180_c();
            vertex.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertex.func_227888_a_(model, -0.1f, 0.1f, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue(), ((Float)coordinates.getRight()).floatValue() + 0.25f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, 0.1f, 0.1f, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue() + 0.25f, ((Float)coordinates.getRight()).floatValue() + 0.25f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, 0.1f, -0.1f, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue() + 0.25f, ((Float)coordinates.getRight()).floatValue()).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, -0.1f, -0.1f, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue(), ((Float)coordinates.getRight()).floatValue()).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_178977_d();
            RenderSystem.enableAlphaTest();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertex);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            model = matrixStack.func_227866_c_().func_227870_a_();
            normal = matrixStack.func_227866_c_().func_227872_b_();
            vertex = Tessellator.func_178181_a().func_178180_c();
            vertex.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertex.func_227888_a_(model, -size, size, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue(), ((Float)coordinates.getRight()).floatValue() + 0.25f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, size, size, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue() + 0.25f, ((Float)coordinates.getRight()).floatValue() + 0.25f).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, size, -size, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue() + 0.25f, ((Float)coordinates.getRight()).floatValue()).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_227888_a_(model, -size, -size, 0.0f).func_225586_a_(1, 1, 1, 1).func_225583_a_(((Float)coordinates.getLeft()).floatValue(), ((Float)coordinates.getRight()).floatValue()).func_227891_b_(overlay).func_227886_a_(0xF000F0).func_227887_a_(normal, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertex.func_178977_d();
            RenderSystem.enableAlphaTest();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertex);
            matrixStack.func_227865_b_();
        }
    }
}

