/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.client.RediscoveredClientEvents;
import com.legacy.rediscovered.client.RediscoveredColors;
import com.legacy.rediscovered.client.RediscoveredEntityRendering;
import com.legacy.rediscovered.client.RediscoveredTileEntityRendering;
import com.legacy.rediscovered.client.resource_pack.RediscoveredResourcePackHandler;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.event.RediscoveredEvents;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredFeatures;
import com.legacy.rediscovered.world.AnvilRecipeManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="rediscovered")
public class RediscoveredMod {
    public static final String NAME = "Rediscovered Mod";
    public static final String MODID = "rediscovered";
    public static AnvilRecipeManager anvilRecipeManager = new AnvilRecipeManager();

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return new String("rediscovered:" + key);
    }

    public RediscoveredMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RediscoveredConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RediscoveredConfig.SERVER_SPEC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RediscoveredResourcePackHandler.init();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientLoadComplete);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(event -> RediscoveredFeatures.addFeatures(event));
    }

    private void commonInit(FMLCommonSetupEvent event) {
        RediscoveredTags.Blocks.init();
        RediscoveredTags.Items.init();
        MinecraftForge.EVENT_BUS.register((Object)new RediscoveredEvents());
    }

    public void clientInit(FMLClientSetupEvent event) {
        RediscoveredClientEvents.initDimensionRenderInfo();
        RediscoveredEntityRendering.init();
        RediscoveredTileEntityRendering.init();
        RediscoveredColors.ItemCol.init();
        MinecraftForge.EVENT_BUS.register((Object)new RediscoveredClientEvents());
        RediscoveredMod.renderCutout(RediscoveredBlocks.empty_rose_bush);
        RediscoveredMod.renderCutout(RediscoveredBlocks.empty_peony_bush);
        RediscoveredMod.renderCutout(RediscoveredBlocks.rose);
        RediscoveredMod.renderCutout(RediscoveredBlocks.paeonia);
        RediscoveredMod.renderCutout(RediscoveredBlocks.cherry_sapling);
        RediscoveredMod.renderCutout(RediscoveredBlocks.potted_rose);
        RediscoveredMod.renderCutout(RediscoveredBlocks.potted_paeonia);
        RediscoveredMod.renderCutout(RediscoveredBlocks.potted_cherry_sapling);
        RediscoveredMod.renderCutout(RediscoveredBlocks.gear);
        RediscoveredMod.renderCutout(RediscoveredBlocks.lantern);
        RediscoveredMod.renderCutout(RediscoveredBlocks.spikes);
        RediscoveredMod.renderCutout(RediscoveredBlocks.cherry_door);
        RediscoveredMod.renderCutout(RediscoveredBlocks.cherry_trapdoor);
    }

    private static void renderCutout(Block block) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
    }

    public void clientLoadComplete(FMLLoadCompleteEvent event) {
        RediscoveredEntityRendering.initLayers();
    }

    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)anvilRecipeManager);
    }
}

