/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.block;

import com.legacy.rediscovered.tile_entity.GearTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GearBlock
extends ContainerBlock {
    public GearBlock(AbstractBlock.Properties properties) {
        super(properties);
        BlockState defaultState = this.func_176223_P();
        for (EnumFaces enumFace : EnumFaces.values()) {
            defaultState = (BlockState)defaultState.func_206870_a(enumFace.face, (Comparable)((Object)GearStates.NONE));
        }
        this.func_180632_j(defaultState);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (EnumFaces enumFace : EnumFaces.values()) {
            if (!((GearStates)((Object)state.func_177229_b(enumFace.face))).exists() || GearBlock.isSolid(worldIn, pos, enumFace.direction.func_176734_d())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSolid(IWorldReader world, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.func_177972_a(direction.func_176734_d());
        return world.func_180495_p(offsetPos).func_224755_d((IBlockReader)world, offsetPos, direction);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 0);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        for (EnumFaces enumFace : EnumFaces.values()) {
            BlockState updatedState = worldIn.func_180495_p(pos);
            if (updatedState.func_177230_c() != this) {
                return;
            }
            if (!((GearStates)((Object)updatedState.func_177229_b(enumFace.face))).exists() || GearBlock.isSolid((IWorldReader)worldIn, pos, enumFace.direction.func_176734_d())) continue;
            GearBlock.func_220075_c((BlockState)((BlockState)this.func_176223_P().func_206870_a(enumFace.face, (Comparable)((Object)GearStates.GEAR))), (World)worldIn, (BlockPos)pos);
            worldIn.func_175656_a(pos, this.removeGear(updatedState, enumFace));
        }
    }

    public BlockState removeGear(BlockState state, EnumFaces enumFaceIn) {
        state = (BlockState)state.func_206870_a(enumFaceIn.face, (Comparable)((Object)GearStates.NONE));
        boolean hasAFace = false;
        for (EnumFaces enumFace : EnumFaces.values()) {
            if (!((GearStates)((Object)state.func_177229_b(enumFace.face))).exists()) continue;
            hasAFace = true;
        }
        return hasAFace ? state : Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState oldState = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (oldState.func_177230_c() == this) {
            return (BlockState)oldState.func_206870_a(EnumFaces.get((Direction)context.func_196000_l().func_176734_d()).face, (Comparable)((Object)GearStates.GEAR));
        }
        if (this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return (BlockState)this.func_176223_P().func_206870_a(EnumFaces.get((Direction)context.func_196000_l().func_176734_d()).face, (Comparable)((Object)GearStates.GEAR));
        }
        return null;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && !((GearStates)((Object)state.func_177229_b(EnumFaces.get((Direction)useContext.func_196000_l().func_176734_d()).face))).exists()) {
            if (useContext.func_196012_c()) {
                return true;
            }
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (EnumFaces enumFace : EnumFaces.values()) {
            if (!((GearStates)((Object)state.func_177229_b(enumFace.face))).exists()) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)enumFace.shape);
        }
        return shape;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        for (EnumFaces enumFace : EnumFaces.values()) {
            builder.func_206894_a(new Property[]{enumFace.face});
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GearTileEntity();
    }

    public static enum EnumFaces {
        NORTH(Direction.NORTH, "north", Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)),
        SOUTH(Direction.SOUTH, "south", Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)),
        EAST(Direction.EAST, "east", Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        WEST(Direction.WEST, "west", Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)),
        UP(Direction.UP, "up", Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)),
        DOWN(Direction.DOWN, "down", Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));

        public final Direction direction;
        public final EnumProperty<GearStates> face;
        public final VoxelShape shape;

        private EnumFaces(Direction direction, String face, VoxelShape shape) {
            this.direction = direction;
            this.face = EnumProperty.func_177709_a((String)(face + "_gear"), GearStates.class);
            this.shape = shape;
        }

        public static EnumFaces get(Direction direction) {
            for (EnumFaces enumFace : EnumFaces.values()) {
                if (direction != enumFace.direction) continue;
                return enumFace;
            }
            return null;
        }
    }

    public static enum GearStates implements IStringSerializable
    {
        NONE,
        GEAR;


        public boolean exists() {
            return this != NONE;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

