/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.world.dimension.RediscoveredSkyRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RediscoveredClientEvents {
    public static final RenderSkyboxCube PANORAMA_RESOURCES = new RenderSkyboxCube(RediscoveredMod.locate("textures/gui/panorama/panorama"));
    public static final ResourceLocation PANORAMA_OVERLAY = RediscoveredMod.locate("textures/gui/panorama_overlay.png");
    public static final ResourceLocation STEVE_MD3 = RediscoveredMod.locate("models/entity/steve.md3");
    public static final ResourceLocation RANA_MD3 = RediscoveredMod.locate("models/entity/mcexport01.md3");
    private static final DimensionRenderInfo SKY_RENDER_INFO = new SkyRenderInfo();

    public static void initDimensionRenderInfo() {
        Object2ObjectMap renderInfo = (Object2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(DimensionRenderInfo.class, (Object)SKY_RENDER_INFO, (String)"field_239208_a_");
        renderInfo.put((Object)RediscoveredDimensions.SKYLANDS_ID, (Object)SKY_RENDER_INFO);
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen && RediscoveredConfig.skyPanorama) {
            MainMenuScreen.field_213098_a = PANORAMA_RESOURCES;
            MainMenuScreen.field_213099_c = PANORAMA_OVERLAY;
            event.setGui((Screen)new MainMenuScreen());
        }
    }

    public static class SkyRenderInfo
    extends DimensionRenderInfo {
        public SkyRenderInfo() {
            super(0.0f, true, DimensionRenderInfo.FogType.NORMAL, false, false);
        }

        public Vector3d func_230494_a_(Vector3d fogColor, float fogBrightness) {
            return fogColor.func_216372_d((double)(fogBrightness * 0.94f + 0.06f), (double)(fogBrightness * 0.94f + 0.06f), (double)(fogBrightness * 0.91f + 0.09f));
        }

        public boolean func_230493_a_(int posX, int posZ) {
            return false;
        }

        public ISkyRenderHandler getSkyRenderHandler() {
            return RediscoveredSkyRenderer.INSTANCE;
        }
    }
}

