/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client;

import com.legacy.rediscovered.client.render.entity.BeastBoyRenderer;
import com.legacy.rediscovered.client.render.entity.BlackSteveRenderer;
import com.legacy.rediscovered.client.render.entity.FishRenderer;
import com.legacy.rediscovered.client.render.entity.MeleePigmanRenderer;
import com.legacy.rediscovered.client.render.entity.MountableBlockRenderer;
import com.legacy.rediscovered.client.render.entity.PigmanRenderer;
import com.legacy.rediscovered.client.render.entity.PurpleArrowRenderer;
import com.legacy.rediscovered.client.render.entity.RanaRenderer;
import com.legacy.rediscovered.client.render.entity.RangedPigmanRenderer;
import com.legacy.rediscovered.client.render.entity.RedDragonRenderer;
import com.legacy.rediscovered.client.render.entity.ScarecrowRenderer;
import com.legacy.rediscovered.client.render.entity.SpawnerRenderer;
import com.legacy.rediscovered.client.render.entity.SteveRenderer;
import com.legacy.rediscovered.client.render.entity.layer.QuiverArmorLayer;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RediscoveredEntityRendering {
    public static void init() {
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.FISH, FishRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.PIGMAN, PigmanRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.MELEE_PIGMAN, MeleePigmanRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.RANGED_PIGMAN, RangedPigmanRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.STEVE, SteveRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.BLACK_STEVE, BlackSteveRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.BEAST_BOY, BeastBoyRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.RANA, RanaRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.RED_DRAGON, RedDragonRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.SCARECROW, ScarecrowRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.PURPLE_ARROW, PurpleArrowRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.MOUNTABLE_BLOCK, MountableBlockRenderer::new);
        RediscoveredEntityRendering.register(RediscoveredEntityTypes.VANILLA_SPAWNER, SpawnerRenderer::new);
    }

    public static <T extends LivingEntity, M extends BipedModel<T>> void initLayers() {
        for (EntityRenderer renderer : Minecraft.func_71410_x().func_175598_ae().field_78729_o.values()) {
            if (!(renderer instanceof LivingRenderer)) continue;
            RediscoveredEntityRendering.addQuiverLayer((LivingRenderer)renderer);
        }
        RediscoveredEntityRendering.addQuiverLayer((LivingRenderer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default"));
        RediscoveredEntityRendering.addQuiverLayer((LivingRenderer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim"));
    }

    private static <T extends Entity> void register(EntityType<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory);
    }

    private static <T extends LivingEntity, M extends BipedModel<T>> void addQuiverLayer(LivingRenderer<T, M> renderer) {
        renderer.func_177094_a(new QuiverArmorLayer<T, M>(renderer));
    }
}

